/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.ExportableColumn;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.mapping.Table;
import org.hibernate.type.LongType;
import org.jboss.logging.Logger;

public class TableStructure
implements DatabaseStructure {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TableStructure.class.getName());
    private final QualifiedName logicalQualifiedTableName;
    private final Identifier logicalValueColumnNameIdentifier;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private String tableNameText;
    private String valueColumnNameText;
    private String selectQuery;
    private String updateQuery;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public TableStructure(JdbcEnvironment jdbcEnvironment, QualifiedName qualifiedTableName, Identifier valueColumnNameIdentifier, int initialValue, int incrementSize, Class numberType) {
        this.logicalQualifiedTableName = qualifiedTableName;
        this.logicalValueColumnNameIdentifier = valueColumnNameIdentifier;
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
        this.numberType = numberType;
    }

    @Override
    public String getName() {
        return this.tableNameText;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public int getIncrementSize() {
        return this.incrementSize;
    }

    @Override
    public int getTimesAccessed() {
        return this.accessCounter;
    }

    @Override
    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    private IntegralDataTypeHolder makeValue() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.numberType);
    }

    @Override
    public AccessCallback buildCallback(final SessionImplementor session) {
        final SqlStatementLogger statementLogger = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlStatementLogger();
        if (this.selectQuery == null || this.updateQuery == null) {
            throw new AssertionFailure("SequenceStyleGenerator's TableStructure was not properly initialized");
        }
        final SessionEventListenerManager statsCollector = session.getEventListenerManager();
        return new AccessCallback(){

            @Override
            public IntegralDataTypeHolder getNextValue() {
                return session.getTransactionCoordinator().createIsolationDelegate().delegateWork(new AbstractReturningWork<IntegralDataTypeHolder>(){

                    @Override
                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        int rows;
                        IntegralDataTypeHolder value = TableStructure.this.makeValue();
                        do {
                            PreparedStatement selectStatement = TableStructure.this.prepareStatement(connection, TableStructure.this.selectQuery, statementLogger, statsCollector);
                            try {
                                ResultSet selectRS = TableStructure.this.executeQuery(selectStatement, statsCollector);
                                if (!selectRS.next()) {
                                    String err = "could not read a hi value - you need to populate the table: " + TableStructure.this.tableNameText;
                                    LOG.error(err);
                                    throw new IdentifierGenerationException(err);
                                }
                                value.initialize(selectRS, 1L);
                                selectRS.close();
                            }
                            catch (SQLException sqle) {
                                LOG.error("could not read a hi value", sqle);
                                throw sqle;
                            }
                            finally {
                                selectStatement.close();
                            }
                            PreparedStatement updatePS = TableStructure.this.prepareStatement(connection, TableStructure.this.updateQuery, statementLogger, statsCollector);
                            try {
                                int increment = TableStructure.this.applyIncrementSizeToSourceValues ? TableStructure.this.incrementSize : 1;
                                IntegralDataTypeHolder updateValue = value.copy().add(increment);
                                updateValue.bind(updatePS, 1);
                                value.bind(updatePS, 2);
                                rows = TableStructure.this.executeUpdate(updatePS, statsCollector);
                            }
                            catch (SQLException e) {
                                LOG.unableToUpdateQueryHiValue(TableStructure.this.tableNameText, e);
                                throw e;
                            }
                            finally {
                                updatePS.close();
                            }
                        } while (rows == 0);
                        TableStructure.this.accessCounter++;
                        return value;
                    }
                }, true);
            }

            @Override
            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(Connection connection, String sql, SqlStatementLogger statementLogger, SessionEventListenerManager statsCollector) throws SQLException {
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
        try {
            statsCollector.jdbcPrepareStatementStart();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return preparedStatement;
        }
        finally {
            statsCollector.jdbcPrepareStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableNameText + " ( " + this.valueColumnNameText + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableNameText + " values ( " + this.initialValue + " )"};
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getDropTableString(this.tableNameText)};
    }

    @Override
    public boolean isPhysicalSequence() {
        return false;
    }

    @Override
    public void registerExportables(Database database) {
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        Namespace namespace = database.locateNamespace(this.logicalQualifiedTableName.getCatalogName(), this.logicalQualifiedTableName.getSchemaName());
        Table table = namespace.locateTable(this.logicalQualifiedTableName.getObjectName());
        if (table == null) {
            table = namespace.createTable(this.logicalQualifiedTableName.getObjectName(), false);
        }
        this.tableNameText = jdbcEnvironment.getQualifiedObjectNameFormatter().format(table.getQualifiedTableName(), dialect);
        this.valueColumnNameText = this.logicalValueColumnNameIdentifier.render(dialect);
        this.selectQuery = "select " + this.valueColumnNameText + " as id_val" + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, this.tableNameText) + dialect.getForUpdateString();
        this.updateQuery = "update " + this.tableNameText + " set " + this.valueColumnNameText + "= ?" + " where " + this.valueColumnNameText + "=?";
        ExportableColumn valueColumn = new ExportableColumn(database, table, this.valueColumnNameText, LongType.INSTANCE);
        table.addColumn(valueColumn);
        database.addInitCommand(new InitCommand("insert into " + this.tableNameText + " values ( " + this.initialValue + " )"));
    }
}

