/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javasimon.Manager;
import org.javasimon.console.SimonConsoleRequestProcessor;

public class SimonConsoleFilter
implements Filter {
    private SimonConsoleRequestProcessor requestProcessor;

    public final void init(FilterConfig filterConfig) {
        this.requestProcessor = new SimonConsoleRequestProcessor(filterConfig.getInitParameter("url-prefix"));
        this.requestProcessor.initActionBindings();
        this.pickUpSharedManagerIfExists(filterConfig);
    }

    private void pickUpSharedManagerIfExists(FilterConfig filterConfig) {
        Object managerObject = filterConfig.getServletContext().getAttribute("manager-servlet-ctx-attribute");
        if (managerObject != null && managerObject instanceof Manager) {
            this.requestProcessor.setManager((Manager)managerObject);
        }
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String localPath = request.getRequestURI().substring(request.getContextPath().length());
        if (localPath.startsWith(this.requestProcessor.getUrlPrefix())) {
            this.requestProcessor.processRequest(request, response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

