/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.CallbackSkeleton;

public class LoggingCallback
extends CallbackSkeleton {
    private Logger logger = Logger.getAnonymousLogger();
    private Level level = Level.FINE;

    @Override
    public void onStopwatchStart(Split split) {
        this.logger.log(this.level, "SIMON START: " + split.getStopwatch());
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        this.logger.log(this.level, "SIMON STOP: " + sample.simonToString() + " (" + split.runningFor() + ")");
    }

    @Override
    @Deprecated
    public void onSimonReset(Simon simon) {
        super.onSimonReset(simon);
    }

    @Override
    public void onManagerWarning(String warning, Exception cause) {
        this.logger.log(this.level, "SIMON WARNING: " + warning, cause);
    }

    @Override
    public void onManagerMessage(String message) {
        this.logger.log(this.level, "SIMON MESSAGE: " + message);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLogger(String logger) {
        this.logger = Logger.getLogger(logger);
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setLevel(String level) {
        this.level = Level.parse(level);
    }
}

