/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.util.Util;

public class RelayDemoRpc
extends ReceiverAdapter {
    protected JChannel ch;
    protected RpcDispatcher disp;
    protected String local_addr;
    protected View view;
    protected static final long RPC_TIMEOUT = 10000L;

    public static void main(String[] args) throws Exception {
        String props = "udp.xml";
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            System.out.println("RelayDemo [-props props] [-name name]");
            return;
        }
        RelayDemoRpc demo = new RelayDemoRpc();
        demo.start(props, name);
    }

    /*
     * Unable to fully structure code
     */
    public void start(String props, String name) throws Exception {
        this.ch = new JChannel(props);
        if (name != null) {
            this.ch.setName(name);
        }
        this.disp = new RpcDispatcher((Channel)this.ch, null, (MembershipListener)this, this);
        this.ch.connect("RelayDemo");
        this.local_addr = this.ch.getAddress().toString();
        call = new MethodCall(this.getClass().getMethod("handleMessage", new Class[]{String.class, String.class}));
        block6: while (true) {
            if ((line = Util.readStringFromStdin(": ")).startsWith("help")) {
                System.out.println("unicast <text>  // unicasts to all members of local view\nsite <site>+    // unicasts to all listed site masters, e.g. \"site sfo lon\"\nmcast <site>+   // anycasts to all local members, plus listed site masters \n<text>          // multicast, RELAY2 will relay to all members of sites");
                continue;
            }
            call.setArgs(new Object[]{line, this.local_addr});
            if (line.equalsIgnoreCase("unicast")) {
                var5_5 = this.view.getMembers().iterator();
                while (true) {
                    if (!var5_5.hasNext()) continue block6;
                    dest = var5_5.next();
                    System.out.println("invoking method in " + dest + ": ");
                    try {
                        rsp = this.disp.callRemoteMethod((Address)dest, call, new RequestOptions(ResponseMode.GET_ALL, 10000L));
                        System.out.println("rsp from " + dest + ": " + rsp);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            if (line.startsWith("site")) {
                site_masters = RelayDemoRpc.parseSiteMasters(line.substring("site".length()));
                dest = site_masters.iterator();
                while (true) {
                    if (!dest.hasNext()) continue block6;
                    site_master = (String)dest.next();
                    try {
                        dest = new SiteMaster(site_master);
                        System.out.println("invoking method in " + dest + ": ");
                        rsp = this.disp.callRemoteMethod(dest, call, new RequestOptions(ResponseMode.GET_ALL, 10000L));
                        System.out.println("rsp from " + dest + ": " + rsp);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            if (line.startsWith("mcast")) {
                site_masters = RelayDemoRpc.parseSiteMasters(line.substring("mcast".length()));
                dests = new ArrayList<Address>(site_masters.size());
                for (String site_master : site_masters) {
                    try {
                        dests.add(new SiteMaster(site_master));
                    }
                    catch (Throwable t) {
                        System.err.println("failed adding SiteMaster for " + site_master + ": " + t);
                    }
                }
                dests.addAll(this.view.getMembers());
                System.out.println("invoking method in " + dests + ": ");
                rsps = this.disp.callRemoteMethods(dests, call, new RequestOptions(ResponseMode.GET_ALL, 10000L).setAnycasting(true));
                var8_9 = rsps.values().iterator();
                while (true) {
                    if (!var8_9.hasNext()) continue block6;
                    rsp = var8_9.next();
                    if (rsp.wasUnreachable()) {
                        System.out.println("<< unreachable: " + rsp.getSender());
                        continue;
                    }
                    System.out.println("<< " + rsp.getValue() + " from " + rsp.getSender());
                }
            }
            rsps = this.disp.callRemoteMethods(null, call, new RequestOptions(ResponseMode.GET_ALL, 10000L).setAnycasting(false));
            var6_6 = rsps.values().iterator();
            while (true) {
                if (var6_6.hasNext()) ** break;
                continue block6;
                rsp = var6_6.next();
                System.out.println("<< " + rsp.getValue() + " from " + rsp.getSender());
            }
            break;
        }
    }

    protected static Collection<String> parseSiteMasters(String line) {
        String[] tmp;
        HashSet<String> retval = new HashSet<String>();
        for (String s : tmp = line.split("\\s")) {
            String result = s.trim();
            if (result.length() <= 0) continue;
            retval.add(result);
        }
        return retval;
    }

    public static String handleMessage(String msg, String sender) {
        System.out.println("<< " + msg + " from " + sender);
        return "this is a response";
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println(RelayDemoRpc.print(new_view));
        this.view = new_view;
    }

    static String print(View view) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append(view.getClass().getSimpleName() + ": ").append(view.getViewId()).append(": ");
        for (Address mbr : view.getMembers()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(mbr);
        }
        return sb.toString();
    }
}

