/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.money.BigMoneyProvider;
import org.joda.money.CurrencyMismatchException;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;
import org.joda.money.MoneyUtils;
import org.joda.money.Ser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigMoney
implements BigMoneyProvider,
Comparable<BigMoneyProvider>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern PARSE_REGEX = Pattern.compile("[+-]?[0-9]*[.]?[0-9]*");
    private final CurrencyUnit currency;
    private final BigDecimal amount;

    public static BigMoney of(CurrencyUnit currency, BigDecimal amount) {
        MoneyUtils.checkNotNull(currency, "Currency must not be null");
        MoneyUtils.checkNotNull(amount, "Amount must not be null");
        if (amount.getClass() != BigDecimal.class) {
            BigInteger value = amount.unscaledValue();
            if (value == null) {
                throw new IllegalArgumentException("Illegal BigDecimal subclass");
            }
            if (value.getClass() != BigInteger.class) {
                value = new BigInteger(value.toString());
            }
            amount = new BigDecimal(value, amount.scale());
        }
        return new BigMoney(currency, amount);
    }

    public static BigMoney of(CurrencyUnit currency, double amount) {
        MoneyUtils.checkNotNull(currency, "Currency must not be null");
        return BigMoney.of(currency, BigDecimal.valueOf(amount));
    }

    public static BigMoney ofScale(CurrencyUnit currency, BigDecimal amount, int scale) {
        return BigMoney.ofScale(currency, amount, scale, RoundingMode.UNNECESSARY);
    }

    public static BigMoney ofScale(CurrencyUnit currency, BigDecimal amount, int scale, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull(currency, "CurrencyUnit must not be null");
        MoneyUtils.checkNotNull(amount, "Amount must not be null");
        MoneyUtils.checkNotNull((Object)roundingMode, "RoundingMode must not be null");
        amount = amount.setScale(scale, roundingMode);
        return BigMoney.of(currency, amount);
    }

    public static BigMoney ofScale(CurrencyUnit currency, long unscaledAmount, int scale) {
        MoneyUtils.checkNotNull(currency, "Currency must not be null");
        return BigMoney.of(currency, BigDecimal.valueOf(unscaledAmount, scale));
    }

    public static BigMoney ofMajor(CurrencyUnit currency, long amountMajor) {
        MoneyUtils.checkNotNull(currency, "CurrencyUnit must not be null");
        return BigMoney.of(currency, BigDecimal.valueOf(amountMajor));
    }

    public static BigMoney ofMinor(CurrencyUnit currency, long amountMinor) {
        MoneyUtils.checkNotNull(currency, "CurrencyUnit must not be null");
        return BigMoney.of(currency, BigDecimal.valueOf(amountMinor, currency.getDecimalPlaces()));
    }

    public static BigMoney zero(CurrencyUnit currency) {
        return BigMoney.of(currency, BigDecimal.ZERO);
    }

    public static BigMoney zero(CurrencyUnit currency, int scale) {
        return BigMoney.of(currency, BigDecimal.valueOf(0L, scale));
    }

    public static BigMoney of(BigMoneyProvider moneyProvider) {
        MoneyUtils.checkNotNull(moneyProvider, "BigMoneyProvider must not be null");
        BigMoney money = moneyProvider.toBigMoney();
        MoneyUtils.checkNotNull(money, "BigMoneyProvider must not return null");
        return money;
    }

    public static BigMoney total(BigMoneyProvider ... monies) {
        MoneyUtils.checkNotNull(monies, "Money array must not be null");
        if (monies.length == 0) {
            throw new IllegalArgumentException("Money array must not be empty");
        }
        BigMoney total = BigMoney.of(monies[0]);
        MoneyUtils.checkNotNull(total, "Money arary must not contain null entries");
        for (int i = 1; i < monies.length; ++i) {
            total = total.plus(BigMoney.of(monies[i]));
        }
        return total;
    }

    public static BigMoney total(Iterable<? extends BigMoneyProvider> monies) {
        MoneyUtils.checkNotNull(monies, "Money iterator must not be null");
        Iterator<? extends BigMoneyProvider> it = monies.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Money iterator must not be empty");
        }
        BigMoney total = BigMoney.of(it.next());
        MoneyUtils.checkNotNull(total, "Money iterator must not contain null entries");
        while (it.hasNext()) {
            total = total.plus(it.next());
        }
        return total;
    }

    public static BigMoney total(CurrencyUnit currency, BigMoneyProvider ... monies) {
        return BigMoney.zero(currency).plus(Arrays.asList(monies));
    }

    public static BigMoney total(CurrencyUnit currency, Iterable<? extends BigMoneyProvider> monies) {
        return BigMoney.zero(currency).plus(monies);
    }

    @FromString
    public static BigMoney parse(String moneyStr) {
        MoneyUtils.checkNotNull(moneyStr, "Money must not be null");
        if (moneyStr.length() < 5 || moneyStr.charAt(3) != ' ') {
            throw new IllegalArgumentException("Money '" + moneyStr + "' cannot be parsed");
        }
        String currStr = moneyStr.substring(0, 3);
        String amountStr = moneyStr.substring(4);
        if (!PARSE_REGEX.matcher(amountStr).matches()) {
            throw new IllegalArgumentException("Money amount '" + moneyStr + "' cannot be parsed");
        }
        return BigMoney.of(CurrencyUnit.of(currStr), new BigDecimal(amountStr));
    }

    public static BigMoney nonNull(BigMoney money, CurrencyUnit currency) {
        if (money == null) {
            return BigMoney.zero(currency);
        }
        if (!money.getCurrencyUnit().equals(currency)) {
            MoneyUtils.checkNotNull(currency, "Currency must not be null");
            throw new CurrencyMismatchException(money.getCurrencyUnit(), currency);
        }
        return money;
    }

    BigMoney(CurrencyUnit currency, BigDecimal amount) {
        assert (currency != null) : "Joda-Money bug: Currency must not be null";
        assert (amount != null) : "Joda-Money bug: Amount must not be null";
        this.currency = currency;
        this.amount = amount;
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization delegate required");
    }

    private Object writeReplace() {
        return new Ser(66, this);
    }

    private BigMoney with(BigDecimal newAmount) {
        if (newAmount == this.amount) {
            return this;
        }
        return new BigMoney(this.currency, newAmount);
    }

    public CurrencyUnit getCurrencyUnit() {
        return this.currency;
    }

    public BigMoney withCurrencyUnit(CurrencyUnit currency) {
        MoneyUtils.checkNotNull(currency, "CurrencyUnit must not be null");
        if (this.currency == currency) {
            return this;
        }
        return new BigMoney(currency, this.amount);
    }

    public int getScale() {
        return this.amount.scale();
    }

    public boolean isCurrencyScale() {
        return this.amount.scale() == this.currency.getDecimalPlaces();
    }

    public BigMoney withScale(int scale) {
        return this.withScale(scale, RoundingMode.UNNECESSARY);
    }

    public BigMoney withScale(int scale, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull((Object)roundingMode, "RoundingMode must not be null");
        if (scale == this.amount.scale()) {
            return this;
        }
        return BigMoney.of(this.currency, this.amount.setScale(scale, roundingMode));
    }

    public BigMoney withCurrencyScale() {
        return this.withScale(this.currency.getDecimalPlaces(), RoundingMode.UNNECESSARY);
    }

    public BigMoney withCurrencyScale(RoundingMode roundingMode) {
        return this.withScale(this.currency.getDecimalPlaces(), roundingMode);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getAmountMajor() {
        return this.amount.setScale(0, RoundingMode.DOWN);
    }

    public long getAmountMajorLong() {
        return this.getAmountMajor().longValueExact();
    }

    public int getAmountMajorInt() {
        return this.getAmountMajor().intValueExact();
    }

    public BigDecimal getAmountMinor() {
        int cdp = this.getCurrencyUnit().getDecimalPlaces();
        return this.amount.setScale(cdp, RoundingMode.DOWN).movePointRight(cdp);
    }

    public long getAmountMinorLong() {
        return this.getAmountMinor().longValueExact();
    }

    public int getAmountMinorInt() {
        return this.getAmountMinor().intValueExact();
    }

    public int getMinorPart() {
        int cdp = this.getCurrencyUnit().getDecimalPlaces();
        return this.amount.setScale(cdp, RoundingMode.DOWN).remainder(BigDecimal.ONE).movePointRight(cdp).intValueExact();
    }

    public boolean isZero() {
        return this.amount.compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean isPositive() {
        return this.amount.compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isPositiveOrZero() {
        return this.amount.compareTo(BigDecimal.ZERO) >= 0;
    }

    public boolean isNegative() {
        return this.amount.compareTo(BigDecimal.ZERO) < 0;
    }

    public boolean isNegativeOrZero() {
        return this.amount.compareTo(BigDecimal.ZERO) <= 0;
    }

    public BigMoney withAmount(BigDecimal amount) {
        MoneyUtils.checkNotNull(amount, "Amount must not be null");
        if (this.amount.equals(amount)) {
            return this;
        }
        return BigMoney.of(this.currency, amount);
    }

    public BigMoney withAmount(double amount) {
        return this.withAmount(BigDecimal.valueOf(amount));
    }

    private BigMoney checkCurrencyEqual(BigMoneyProvider moneyProvider) {
        BigMoney money = BigMoney.of(moneyProvider);
        if (!this.isSameCurrency(money)) {
            throw new CurrencyMismatchException(this.getCurrencyUnit(), money.getCurrencyUnit());
        }
        return money;
    }

    public BigMoney plus(Iterable<? extends BigMoneyProvider> moniesToAdd) {
        BigDecimal total = this.amount;
        for (BigMoneyProvider bigMoneyProvider : moniesToAdd) {
            BigMoney money = this.checkCurrencyEqual(bigMoneyProvider);
            total = total.add(money.amount);
        }
        return this.with(total);
    }

    public BigMoney plus(BigMoneyProvider moneyToAdd) {
        BigMoney toAdd = this.checkCurrencyEqual(moneyToAdd);
        return this.plus(toAdd.getAmount());
    }

    public BigMoney plus(BigDecimal amountToAdd) {
        MoneyUtils.checkNotNull(amountToAdd, "Amount must not be null");
        if (amountToAdd.compareTo(BigDecimal.ZERO) == 0) {
            return this;
        }
        BigDecimal newAmount = this.amount.add(amountToAdd);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney plus(double amountToAdd) {
        if (amountToAdd == 0.0) {
            return this;
        }
        BigDecimal newAmount = this.amount.add(BigDecimal.valueOf(amountToAdd));
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney plusMajor(long amountToAdd) {
        if (amountToAdd == 0L) {
            return this;
        }
        BigDecimal newAmount = this.amount.add(BigDecimal.valueOf(amountToAdd));
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney plusMinor(long amountToAdd) {
        if (amountToAdd == 0L) {
            return this;
        }
        BigDecimal newAmount = this.amount.add(BigDecimal.valueOf(amountToAdd, this.currency.getDecimalPlaces()));
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney plusRetainScale(BigMoneyProvider moneyToAdd, RoundingMode roundingMode) {
        BigMoney toAdd = this.checkCurrencyEqual(moneyToAdd);
        return this.plusRetainScale(toAdd.getAmount(), roundingMode);
    }

    public BigMoney plusRetainScale(BigDecimal amountToAdd, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull(amountToAdd, "Amount must not be null");
        if (amountToAdd.compareTo(BigDecimal.ZERO) == 0) {
            return this;
        }
        BigDecimal newAmount = this.amount.add(amountToAdd);
        newAmount = newAmount.setScale(this.getScale(), roundingMode);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney plusRetainScale(double amountToAdd, RoundingMode roundingMode) {
        if (amountToAdd == 0.0) {
            return this;
        }
        BigDecimal newAmount = this.amount.add(BigDecimal.valueOf(amountToAdd));
        newAmount = newAmount.setScale(this.getScale(), roundingMode);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney minus(Iterable<? extends BigMoneyProvider> moniesToSubtract) {
        BigDecimal total = this.amount;
        for (BigMoneyProvider bigMoneyProvider : moniesToSubtract) {
            BigMoney money = this.checkCurrencyEqual(bigMoneyProvider);
            total = total.subtract(money.amount);
        }
        return this.with(total);
    }

    public BigMoney minus(BigMoneyProvider moneyToSubtract) {
        BigMoney toSubtract = this.checkCurrencyEqual(moneyToSubtract);
        return this.minus(toSubtract.getAmount());
    }

    public BigMoney minus(BigDecimal amountToSubtract) {
        MoneyUtils.checkNotNull(amountToSubtract, "Amount must not be null");
        if (amountToSubtract.compareTo(BigDecimal.ZERO) == 0) {
            return this;
        }
        BigDecimal newAmount = this.amount.subtract(amountToSubtract);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney minus(double amountToSubtract) {
        if (amountToSubtract == 0.0) {
            return this;
        }
        BigDecimal newAmount = this.amount.subtract(BigDecimal.valueOf(amountToSubtract));
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney minusMajor(long amountToSubtract) {
        if (amountToSubtract == 0L) {
            return this;
        }
        BigDecimal newAmount = this.amount.subtract(BigDecimal.valueOf(amountToSubtract));
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney minusMinor(long amountToSubtract) {
        if (amountToSubtract == 0L) {
            return this;
        }
        BigDecimal newAmount = this.amount.subtract(BigDecimal.valueOf(amountToSubtract, this.currency.getDecimalPlaces()));
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney minusRetainScale(BigMoneyProvider moneyToSubtract, RoundingMode roundingMode) {
        BigMoney toSubtract = this.checkCurrencyEqual(moneyToSubtract);
        return this.minusRetainScale(toSubtract.getAmount(), roundingMode);
    }

    public BigMoney minusRetainScale(BigDecimal amountToSubtract, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull(amountToSubtract, "Amount must not be null");
        if (amountToSubtract.compareTo(BigDecimal.ZERO) == 0) {
            return this;
        }
        BigDecimal newAmount = this.amount.subtract(amountToSubtract);
        newAmount = newAmount.setScale(this.getScale(), roundingMode);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney minusRetainScale(double amountToSubtract, RoundingMode roundingMode) {
        if (amountToSubtract == 0.0) {
            return this;
        }
        BigDecimal newAmount = this.amount.subtract(BigDecimal.valueOf(amountToSubtract));
        newAmount = newAmount.setScale(this.getScale(), roundingMode);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney multipliedBy(BigDecimal valueToMultiplyBy) {
        MoneyUtils.checkNotNull(valueToMultiplyBy, "Multiplier must not be null");
        if (valueToMultiplyBy.compareTo(BigDecimal.ONE) == 0) {
            return this;
        }
        BigDecimal newAmount = this.amount.multiply(valueToMultiplyBy);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney multipliedBy(double valueToMultiplyBy) {
        if (valueToMultiplyBy == 1.0) {
            return this;
        }
        BigDecimal newAmount = this.amount.multiply(BigDecimal.valueOf(valueToMultiplyBy));
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney multipliedBy(long valueToMultiplyBy) {
        if (valueToMultiplyBy == 1L) {
            return this;
        }
        BigDecimal newAmount = this.amount.multiply(BigDecimal.valueOf(valueToMultiplyBy));
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney multiplyRetainScale(BigDecimal valueToMultiplyBy, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull(valueToMultiplyBy, "Multiplier must not be null");
        MoneyUtils.checkNotNull((Object)roundingMode, "RoundingMode must not be null");
        if (valueToMultiplyBy.compareTo(BigDecimal.ONE) == 0) {
            return this;
        }
        BigDecimal newAmount = this.amount.multiply(valueToMultiplyBy);
        newAmount = newAmount.setScale(this.getScale(), roundingMode);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney multiplyRetainScale(double valueToMultiplyBy, RoundingMode roundingMode) {
        return this.multiplyRetainScale(BigDecimal.valueOf(valueToMultiplyBy), roundingMode);
    }

    public BigMoney dividedBy(BigDecimal valueToDivideBy, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull(valueToDivideBy, "Divisor must not be null");
        MoneyUtils.checkNotNull((Object)roundingMode, "RoundingMode must not be null");
        if (valueToDivideBy.compareTo(BigDecimal.ONE) == 0) {
            return this;
        }
        BigDecimal newAmount = this.amount.divide(valueToDivideBy, roundingMode);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney dividedBy(double valueToDivideBy, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull((Object)roundingMode, "RoundingMode must not be null");
        if (valueToDivideBy == 1.0) {
            return this;
        }
        BigDecimal newAmount = this.amount.divide(BigDecimal.valueOf(valueToDivideBy), roundingMode);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney dividedBy(long valueToDivideBy, RoundingMode roundingMode) {
        if (valueToDivideBy == 1L) {
            return this;
        }
        BigDecimal newAmount = this.amount.divide(BigDecimal.valueOf(valueToDivideBy), roundingMode);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney negated() {
        if (this.isZero()) {
            return this;
        }
        return BigMoney.of(this.currency, this.amount.negate());
    }

    public BigMoney abs() {
        return this.isNegative() ? this.negated() : this;
    }

    public BigMoney rounded(int scale, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull((Object)roundingMode, "RoundingMode must not be null");
        if (scale >= this.getScale()) {
            return this;
        }
        int currentScale = this.amount.scale();
        BigDecimal newAmount = this.amount.setScale(scale, roundingMode).setScale(currentScale);
        return BigMoney.of(this.currency, newAmount);
    }

    public BigMoney convertedTo(CurrencyUnit currency, BigDecimal conversionMultipler) {
        MoneyUtils.checkNotNull(currency, "CurrencyUnit must not be null");
        MoneyUtils.checkNotNull(conversionMultipler, "Multiplier must not be null");
        if (this.currency == currency) {
            throw new IllegalArgumentException("Cannot convert to the same currency");
        }
        if (conversionMultipler.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("Cannot convert using a negative conversion multiplier");
        }
        BigDecimal newAmount = this.amount.multiply(conversionMultipler);
        return BigMoney.of(currency, newAmount);
    }

    public BigMoney convertRetainScale(CurrencyUnit currency, BigDecimal conversionMultipler, RoundingMode roundingMode) {
        return this.convertedTo(currency, conversionMultipler).withScale(this.getScale(), roundingMode);
    }

    @Override
    public BigMoney toBigMoney() {
        return this;
    }

    public Money toMoney() {
        return Money.of(this);
    }

    public Money toMoney(RoundingMode roundingMode) {
        return Money.of(this, roundingMode);
    }

    public boolean isSameCurrency(BigMoneyProvider money) {
        return this.currency.equals(BigMoney.of(money).getCurrencyUnit());
    }

    @Override
    public int compareTo(BigMoneyProvider other) {
        BigMoney otherMoney = BigMoney.of(other);
        if (!this.currency.equals(otherMoney.currency)) {
            throw new CurrencyMismatchException(this.getCurrencyUnit(), otherMoney.getCurrencyUnit());
        }
        return this.amount.compareTo(otherMoney.amount);
    }

    public boolean isEqual(BigMoneyProvider other) {
        return this.compareTo(other) == 0;
    }

    public boolean isGreaterThan(BigMoneyProvider other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(BigMoneyProvider other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BigMoney) {
            BigMoney otherMoney = (BigMoney)other;
            return this.currency.equals(otherMoney.getCurrencyUnit()) && this.amount.equals(otherMoney.amount);
        }
        return false;
    }

    public int hashCode() {
        return this.currency.hashCode() ^ this.amount.hashCode();
    }

    @ToString
    public String toString() {
        return this.currency.getCode() + ' ' + this.amount.toPlainString();
    }
}

