/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeManagerPoolConfig;
import org.jodconverter.office.TemporaryFileMaker;
import org.jodconverter.task.OfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOfficeManagerPool
implements OfficeManager,
TemporaryFileMaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManagerPool.class);
    private static final int POOL_STOPPED = 0;
    private static final int POOL_STARTED = 1;
    private static final int POOL_SHUTDOWN = 2;
    private final AtomicInteger poolState = new AtomicInteger(0);
    protected final OfficeManagerPoolConfig config;
    private final BlockingQueue<OfficeManager> pool;
    private final AtomicLong tempFileCounter;
    private OfficeManager[] entries;
    private File tempDir;

    private static File makeTempDir(File workingDir) {
        File tempDir = new File(workingDir, "jodconverter_" + UUID.randomUUID().toString());
        tempDir.mkdir();
        if (!tempDir.isDirectory()) {
            throw new IllegalStateException(String.format("Cannot create temp directory: %s", tempDir));
        }
        return tempDir;
    }

    protected AbstractOfficeManagerPool(int poolSize, OfficeManagerPoolConfig config) {
        this.config = config;
        this.pool = new ArrayBlockingQueue<OfficeManager>(poolSize);
        this.tempFileCounter = new AtomicLong(0L);
    }

    protected abstract OfficeManager[] createPoolEntries();

    @Override
    public void execute(OfficeTask task) throws OfficeException {
        if (!this.isRunning()) {
            throw new IllegalStateException("This office manager is not running.");
        }
        OfficeManager entry = null;
        try {
            entry = this.acquireManager();
            entry.execute(task);
        }
        finally {
            if (entry != null) {
                this.releaseManager(entry);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.poolState.get() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws OfficeException {
        AbstractOfficeManagerPool abstractOfficeManagerPool = this;
        synchronized (abstractOfficeManagerPool) {
            if (this.poolState.get() == 2) {
                throw new IllegalStateException("This office manager has been shutdown.");
            }
            if (this.poolState.get() == 1) {
                throw new IllegalStateException("This office manager is already running.");
            }
            this.entries = this.createPoolEntries();
            this.doStart();
            this.tempDir = AbstractOfficeManagerPool.makeTempDir(this.config.getWorkingDir());
            this.poolState.set(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws OfficeException {
        AbstractOfficeManagerPool abstractOfficeManagerPool = this;
        synchronized (abstractOfficeManagerPool) {
            if (this.poolState.get() == 2) {
                return;
            }
            this.poolState.set(2);
            try {
                this.doStop();
            }
            finally {
                this.deleteTempDir();
            }
        }
    }

    @Override
    public File makeTemporaryFile(String extension) {
        return new File(this.tempDir, "tempfile_" + this.tempFileCounter.getAndIncrement() + "." + extension);
    }

    private OfficeManager acquireManager() throws OfficeException {
        try {
            OfficeManager manager = this.pool.poll(this.config.getTaskQueueTimeout(), TimeUnit.MILLISECONDS);
            if (manager == null) {
                throw new OfficeException("No office manager available after " + this.config.getTaskQueueTimeout() + " millisec.");
            }
            return manager;
        }
        catch (InterruptedException interruptedEx) {
            throw new OfficeException("Thread has been interrupted while waiting for a manager to become available.", interruptedEx);
        }
    }

    private void releaseManager(OfficeManager manager) throws OfficeException {
        try {
            this.pool.put(manager);
        }
        catch (InterruptedException interruptedEx) {
            throw new OfficeException("interrupted", interruptedEx);
        }
    }

    protected void doStart() throws OfficeException {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i].start();
            this.releaseManager(this.entries[i]);
        }
    }

    private void doStop() throws OfficeException {
        LOGGER.info("Stopping the office manager pool...");
        this.pool.clear();
        OfficeException firstException = null;
        for (int i = 0; i < this.entries.length; ++i) {
            try {
                this.entries[i].stop();
                continue;
            }
            catch (OfficeException ex) {
                if (firstException != null) continue;
                firstException = ex;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        LOGGER.info("Office manager stopped");
    }

    private void deleteTempDir() {
        if (this.tempDir != null) {
            LOGGER.debug("Deleting temporary directory '{}'", (Object)this.tempDir);
            try {
                FileUtils.deleteDirectory((File)this.tempDir);
            }
            catch (IOException ioEx) {
                LOGGER.error("Could not temporary profileDir: {}", (Object)ioEx.getMessage());
            }
        }
    }

    public static abstract class AbstractOfficeManagerPoolBuilder<B extends AbstractOfficeManagerPoolBuilder<B>> {
        protected boolean install;
        protected File workingDir;
        protected long taskExecutionTimeout = 120000L;
        protected long taskQueueTimeout = 30000L;

        protected AbstractOfficeManagerPoolBuilder() {
        }

        public B install() {
            this.install = true;
            return (B)this;
        }

        public B workingDir(File workingDir) {
            this.workingDir = workingDir;
            return (B)this;
        }

        public B workingDir(String workingDir) {
            return (B)(StringUtils.isBlank((CharSequence)workingDir) ? this : this.workingDir(new File(workingDir)));
        }

        public B taskExecutionTimeout(long taskExecutionTimeout) {
            Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)taskExecutionTimeout, (String)String.format("The taskExecutionTimeout %s must greater than or equal to 0", taskExecutionTimeout));
            this.taskExecutionTimeout = taskExecutionTimeout;
            return (B)this;
        }

        public B taskQueueTimeout(long taskQueueTimeout) {
            Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)taskQueueTimeout, (String)String.format("The taskQueueTimeout %s must greater than or equal to 0", taskQueueTimeout));
            this.taskQueueTimeout = taskQueueTimeout;
            return (B)this;
        }

        protected abstract AbstractOfficeManagerPool build();
    }
}

