/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.task;

import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.office.LocalOfficeContext;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeException;
import org.jodconverter.task.AbstractOfficeTask;

public abstract class AbstractLocalOfficeTask
extends AbstractOfficeTask {
    private static final String ERROR_MESSAGE_LOAD = "Could not open document: ";
    protected static final Map<String, Object> DEFAULT_LOAD_PROPERTIES;
    protected Map<String, Object> loadProperties;

    protected static void addPropertiesToMap(Map<String, Object> properties, Map<String, Object> toAddProperties) {
        if (toAddProperties != null) {
            properties.putAll(toAddProperties);
        }
    }

    public AbstractLocalOfficeTask(SourceDocumentSpecs source) {
        this(source, null);
    }

    public AbstractLocalOfficeTask(SourceDocumentSpecs source, Map<String, Object> loadProperties) {
        super(source);
        this.loadProperties = loadProperties;
    }

    protected Map<String, Object> getLoadProperties() {
        HashMap<String, Object> loadProps = new HashMap<String, Object>(this.loadProperties == null ? DEFAULT_LOAD_PROPERTIES : this.loadProperties);
        AbstractLocalOfficeTask.addPropertiesToMap(loadProps, this.source.getFormat().getLoadProperties());
        return loadProps;
    }

    protected XComponent loadDocument(LocalOfficeContext context, File sourceFile) throws OfficeException {
        try {
            XComponent document = context.getComponentLoader().loadComponentFromURL(LocalOfficeUtils.toUrl(sourceFile), "_blank", 0, LocalOfficeUtils.toUnoProperties(this.getLoadProperties()));
            Validate.notNull((Object)document, (String)(ERROR_MESSAGE_LOAD + sourceFile.getName()), (Object[])new Object[0]);
            return document;
        }
        catch (IllegalArgumentException illegalArgumentEx) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName(), (Throwable)illegalArgumentEx);
        }
        catch (ErrorCodeIOException errorCodeIoEx) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName() + "; errorCode: " + errorCodeIoEx.ErrCode, (Throwable)errorCodeIoEx);
        }
        catch (IOException ioEx) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName(), (Throwable)ioEx);
        }
    }

    protected void closeDocument(XComponent document) {
        if (document != null) {
            XCloseable closeable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)document);
            if (closeable == null) {
                ((XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)document)).dispose();
            } else {
                try {
                    closeable.close(true);
                }
                catch (CloseVetoException closeVetoException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        HashMap<String, Comparable<Boolean>> loadProperties = new HashMap<String, Comparable<Boolean>>();
        loadProperties.put("Hidden", Boolean.valueOf(true));
        loadProperties.put("ReadOnly", Boolean.valueOf(true));
        loadProperties.put("UpdateDocMode", Short.valueOf((short)1));
        DEFAULT_LOAD_PROPERTIES = Collections.unmodifiableMap(loadProperties);
    }
}

