/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.job;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.document.DocumentFormat;
import org.jodconverter.document.DocumentFormatRegistry;
import org.jodconverter.job.AbstractConversionJob;
import org.jodconverter.job.AbstractSourceDocumentSpecs;
import org.jodconverter.job.AbstractTargetDocumentSpecs;
import org.jodconverter.job.ConversionJobWithOptionalSourceFormatUnspecified;
import org.jodconverter.job.TargetDocumentSpecsFromFile;
import org.jodconverter.job.TargetDocumentSpecsFromOutputStream;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.TemporaryFileMaker;

public abstract class AbstractConversionJobWithSourceFormatUnspecified
implements ConversionJobWithOptionalSourceFormatUnspecified {
    private static final boolean DEFAULT_CLOSE_STREAM = true;
    protected final AbstractSourceDocumentSpecs source;
    protected final OfficeManager officeManager;
    protected final DocumentFormatRegistry formatRegistry;

    protected AbstractConversionJobWithSourceFormatUnspecified(AbstractSourceDocumentSpecs source, OfficeManager officeManager, DocumentFormatRegistry formatRegistry) {
        this.source = source;
        this.officeManager = officeManager;
        this.formatRegistry = formatRegistry;
    }

    @Override
    public AbstractConversionJobWithSourceFormatUnspecified as(DocumentFormat format) {
        this.source.setDocumentFormat(format);
        return this;
    }

    @Override
    public AbstractConversionJob to(File target) {
        TargetDocumentSpecsFromFile specs = new TargetDocumentSpecsFromFile(target);
        DocumentFormat format = this.formatRegistry.getFormatByExtension(FilenameUtils.getExtension((String)target.getName()));
        if (format != null) {
            specs.setDocumentFormat(format);
        }
        return this.toInternal(specs);
    }

    @Override
    public AbstractConversionJob to(OutputStream target) {
        return this.to(target, true);
    }

    @Override
    public AbstractConversionJob to(OutputStream target, boolean closeStream) {
        if (this.officeManager instanceof TemporaryFileMaker) {
            return this.toInternal(new TargetDocumentSpecsFromOutputStream(target, ((TemporaryFileMaker)((Object)this.officeManager)).makeTemporaryFile("tmp"), closeStream));
        }
        throw new IllegalStateException("An office manager must implements the TemporaryFileMaker interface in order to be able to convert to OutputStream.");
    }

    protected abstract AbstractConversionJob to(AbstractTargetDocumentSpecs var1);

    private AbstractConversionJob toInternal(AbstractTargetDocumentSpecs target) {
        Validate.notNull((Object)this.source.getFormat(), (String)"The source format is missing or not supported", (Object[])new Object[0]);
        return this.to(target);
    }
}

