/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.document;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jodconverter.document.DocumentFamily;

public class DocumentFormat {
    private final String name;
    private final String extension;
    private final String mediaType;
    private final DocumentFamily inputFamily;
    private final Map<String, Object> loadProperties;
    @SerializedName(value="storeProperties", alternate={"storePropertiesByFamily"})
    private final Map<DocumentFamily, Map<String, Object>> storeProperties;

    public static DocumentFormat copy(DocumentFormat sourceFormat) {
        return new DocumentFormat(sourceFormat.getName(), sourceFormat.getExtension(), sourceFormat.getMediaType(), sourceFormat.getInputFamily(), sourceFormat.getLoadProperties(), sourceFormat.getStoreProperties(), false);
    }

    DocumentFormat(String name, String extension, String mediaType, DocumentFamily inputFamily, Map<String, Object> loadProperties, Map<DocumentFamily, Map<String, Object>> storeProperties, boolean readOnly) {
        this.name = name;
        this.extension = extension;
        this.mediaType = mediaType;
        this.inputFamily = inputFamily;
        this.loadProperties = loadProperties == null ? null : (readOnly ? Collections.unmodifiableMap(new HashMap<String, Object>(loadProperties)) : new HashMap<String, Object>(loadProperties));
        EnumMap<DocumentFamily, HashMap<String, Object>> storeProps = null;
        if (storeProperties != null) {
            storeProps = new EnumMap<DocumentFamily, HashMap<String, Object>>(DocumentFamily.class);
            for (Map.Entry<DocumentFamily, Map<String, Object>> entry : storeProperties.entrySet()) {
                storeProps.put(entry.getKey(), (HashMap<String, Object>)(readOnly ? Collections.unmodifiableMap(new HashMap<String, Object>(entry.getValue())) : new HashMap<String, Object>(entry.getValue())));
            }
        }
        this.storeProperties = storeProps == null ? null : (readOnly ? Collections.unmodifiableMap(storeProps) : storeProps);
    }

    public String getExtension() {
        return this.extension;
    }

    public DocumentFamily getInputFamily() {
        return this.inputFamily;
    }

    public Map<String, Object> getLoadProperties() {
        return this.loadProperties;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getName() {
        return this.name;
    }

    public Map<DocumentFamily, Map<String, Object>> getStoreProperties() {
        return this.storeProperties;
    }

    public Map<String, Object> getStoreProperties(DocumentFamily family) {
        return this.storeProperties == null ? null : this.storeProperties.get((Object)family);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

