/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.job;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.job.AbstractTargetDocumentSpecs;
import org.jodconverter.job.DocumentSpecsIOException;
import org.jodconverter.job.TargetDocumentSpecs;

class TargetDocumentSpecsFromOutputStream
extends AbstractTargetDocumentSpecs
implements TargetDocumentSpecs {
    private final OutputStream outputStream;
    private final boolean closeStream;

    public TargetDocumentSpecsFromOutputStream(OutputStream outputStream, File tempFile, boolean closeStream) {
        super(tempFile);
        Validate.notNull((Object)outputStream, (String)"The outputStream is null", (Object[])new Object[0]);
        this.outputStream = outputStream;
        this.closeStream = closeStream;
    }

    @Override
    public void onComplete(File tempFile) {
        try {
            FileUtils.copyFile((File)tempFile, (OutputStream)this.outputStream);
            if (this.closeStream) {
                IOUtils.closeQuietly((OutputStream)this.outputStream);
            }
        }
        catch (IOException ex) {
            throw new DocumentSpecsIOException("Could not write file '" + tempFile + "' to stream", ex);
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    @Override
    public void onFailure(File tempFile, Exception exception) {
        FileUtils.deleteQuietly((File)tempFile);
    }
}

