/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.modelmapper.internal.util.ArrayIterator;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IterableConverter<S, D>
implements ConditionalConverter<S, D> {
    IterableConverter() {
    }

    @Override
    public D convert(MappingContext<S, D> context) {
        S source = context.getSource();
        if (source == null) {
            return null;
        }
        int sourceLength = this.getSourceLength(source);
        D destination = context.getDestination() == null ? this.createDestination(context, sourceLength) : context.getDestination();
        Class<?> elementType = this.getElementType(context);
        int index = 0;
        Iterator<Object> iterator = this.getSourceIterator(source);
        while (iterator.hasNext()) {
            Object sourceElement = iterator.next();
            Object element = null;
            if (sourceElement != null) {
                MappingContext<Object, ?> elementContext = context.create(sourceElement, elementType);
                element = context.getMappingEngine().map(elementContext);
            }
            this.setElement(destination, element, index);
            ++index;
        }
        return destination;
    }

    protected abstract D createDestination(MappingContext<S, D> var1, int var2);

    protected Class<?> getElementType(MappingContext<S, D> context) {
        return Object.class;
    }

    protected Iterator<Object> getSourceIterator(S source) {
        return source.getClass().isArray() ? new ArrayIterator(source) : ((Iterable)source).iterator();
    }

    protected int getSourceLength(S source) {
        return source.getClass().isArray() ? Array.getLength(source) : ((Collection)source).size();
    }

    protected abstract void setElement(D var1, Object var2, int var3);
}

