/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Calendar;
import java.util.Date;
import org.modelmapper.internal.asm.Type;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Types {
    private static Class<?> JAVASSIST_PROXY_FACTORY_CLASS;
    private static Method JAVASSIST_IS_PROXY_CLASS_METHOD;

    public static <T> Class<T> deProxy(Class<?> type) {
        if (type.isInterface()) {
            return type;
        }
        boolean isProxy = false;
        if (type.getName().contains("$$EnhancerBy")) {
            isProxy = true;
        }
        if (Proxy.isProxyClass(type)) {
            isProxy = true;
        }
        try {
            if (JAVASSIST_IS_PROXY_CLASS_METHOD != null && JAVASSIST_IS_PROXY_CLASS_METHOD != null && ((Boolean)JAVASSIST_IS_PROXY_CLASS_METHOD.invoke(null, type)).booleanValue()) {
                isProxy = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isProxy) {
            Class<?> superclass = type.getSuperclass();
            if (!superclass.equals(Object.class) && !superclass.equals(Proxy.class)) {
                return superclass;
            }
            Class<?>[] interfaces = type.getInterfaces();
            if (interfaces.length > 0) {
                return interfaces[0];
            }
        }
        return type;
    }

    public static boolean isGroovyType(Class<?> type) {
        return type.getName().startsWith("org.codehaus.groovy");
    }

    public static boolean isInstantiable(Class<?> type) {
        return !type.isEnum() && !type.isAssignableFrom(String.class) && !Primitives.isPrimitiveWrapper(type);
    }

    public static Class<?> rawTypeFor(java.lang.reflect.Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            java.lang.reflect.Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Types.rawTypeFor(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Types.rawTypeFor(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return Types.rawTypeFor(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Could not determine raw type for " + className);
    }

    public static Class<?> classFor(Type type, ClassLoader classLoader) throws ClassNotFoundException {
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 9: {
                return Array.newInstance(Types.classFor(type.getElementType(), classLoader), new int[type.getDimensions()]).getClass();
            }
        }
        return Class.forName(type.getClassName(), true, classLoader);
    }

    public static String toString(Member member) {
        if (member instanceof Method) {
            return member.getDeclaringClass().getName() + "." + member.getName() + "()";
        }
        if (member instanceof Field) {
            return member.getDeclaringClass().getName() + "." + member.getName();
        }
        if (member instanceof Constructor) {
            return member.getDeclaringClass().getName() + ".<init>()";
        }
        return null;
    }

    public static String toString(java.lang.reflect.Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    public static boolean mightContainsProperties(Class<?> type) {
        return type != Object.class && type != String.class && type != Date.class && type != Calendar.class && !Primitives.isPrimitive(type) && !Iterables.isIterable(type) && !Types.isGroovyType(type);
    }

    static {
        try {
            JAVASSIST_PROXY_FACTORY_CLASS = Types.class.getClassLoader().loadClass("javassist.util.proxy.ProxyFactory");
            JAVASSIST_IS_PROXY_CLASS_METHOD = JAVASSIST_PROXY_FACTORY_CLASS.getMethod("isProxyClass", Class.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

