/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.Types;

public class TypeToken<T> {
    private final Type type;
    private final Class<T> rawType;

    protected TypeToken() {
        Type superclass = this.getClass().getGenericSuperclass();
        Assert.isTrue(superclass instanceof ParameterizedType, "%s is not parameterized", superclass);
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        Assert.isTrue(!(this.type instanceof TypeVariable), "Cannot construct a TypeToken for a TypeVariable. Try new TypeToken<%s>(getClass()) instead.", this.type);
        this.rawType = Types.rawTypeFor(this.type);
    }

    private TypeToken(Type type) {
        this.type = type;
        this.rawType = Types.rawTypeFor(type);
    }

    public static <T> TypeToken<T> of(Type type) {
        Assert.notNull(type, "type");
        return new TypeToken<T>(type);
    }

    public final boolean equals(Object o) {
        return o instanceof TypeToken && this.type.equals(((TypeToken)o).type);
    }

    public final Class<T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    public final int hashCode() {
        return this.type.hashCode();
    }

    public final String toString() {
        return this.type.toString();
    }
}

