/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import java.util.List;
import org.modelmapper.spi.MatchingStrategy;

final class StrictMatchingStrategy
implements MatchingStrategy {
    StrictMatchingStrategy() {
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public boolean matches(MatchingStrategy.PropertyNameInfo propertyNameInfo) {
        List<String[]> sourceTokens = propertyNameInfo.getSourcePropertyTokens();
        List<String[]> destTokens = propertyNameInfo.getDestinationPropertyTokens();
        if (sourceTokens.size() != destTokens.size()) {
            return false;
        }
        for (int propIndex = 0; propIndex < destTokens.size(); ++propIndex) {
            String[] dTokens;
            String[] sTokens = sourceTokens.get(propIndex);
            if (sTokens.length != (dTokens = destTokens.get(propIndex)).length) {
                return false;
            }
            for (int tokenIndex = 0; tokenIndex < sTokens.length; ++tokenIndex) {
                if (sTokens[tokenIndex].equalsIgnoreCase(dTokens[tokenIndex])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "Strict";
    }
}

