/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.modelmapper.ConfigurationException;
import org.modelmapper.MappingException;
import org.modelmapper.TypeMap;
import org.modelmapper.ValidationException;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.util.Strings;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ErrorMessage;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

public final class Errors {
    private List<ErrorMessage> errors;
    private static final Converter<?>[] converters = new Converter[]{new Converter<Class>(Class.class){

        @Override
        public String toString(Class type) {
            return type.getName();
        }
    }, new Converter<Member>(Member.class){

        @Override
        public String toString(Member member) {
            return Types.toString(member);
        }
    }, new Converter<PropertyInfo>(PropertyInfo.class){

        @Override
        public String toString(PropertyInfo propertyInfo) {
            return Types.toString(propertyInfo.getMember());
        }
    }, new Converter<Collection>(Collection.class){

        @Override
        public String toString(Collection collection) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (Object o : collection) {
                if (first) {
                    first = false;
                } else {
                    builder.append("\n");
                }
                builder.append("\t").append(Errors.convert(o));
            }
            return builder.toString();
        }
    }};

    public static String format(String heading, Collection<ErrorMessage> errorMessages) {
        Formatter fmt = new Formatter().format(heading, new Object[0]).format(":%n%n", new Object[0]);
        int index = 1;
        boolean displayCauses = Errors.getOnlyCause(errorMessages) == null;
        for (ErrorMessage errorMessage : errorMessages) {
            fmt.format("%s) %s%n", index++, errorMessage.getMessage());
            Throwable cause = errorMessage.getCause();
            if (displayCauses && cause != null) {
                StringWriter writer = new StringWriter();
                cause.printStackTrace(new PrintWriter(writer));
                fmt.format("Caused by: %s", writer.getBuffer());
            }
            fmt.format("%n", new Object[0]);
        }
        if (errorMessages.size() == 1) {
            fmt.format("1 error", new Object[0]);
        } else {
            fmt.format("%s errors", errorMessages.size());
        }
        return fmt.toString();
    }

    public static String format(String messageFormat, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = Errors.convert(arguments[i]);
        }
        return String.format(messageFormat, arguments);
    }

    public static Throwable getOnlyCause(Collection<ErrorMessage> messages) {
        Throwable onlyCause = null;
        for (ErrorMessage message : messages) {
            Throwable messageCause = message.getCause();
            if (messageCause == null) continue;
            if (onlyCause != null) {
                return null;
            }
            onlyCause = messageCause;
        }
        return onlyCause;
    }

    private static Object convert(Object source) {
        for (Converter<?> converter : converters) {
            if (!converter.appliesTo(source)) continue;
            return converter.convert(source);
        }
        return source;
    }

    public Errors addMessage(Throwable cause, String message, Object ... arguments) {
        this.addMessage(new ErrorMessage(Errors.format(message, arguments), cause));
        return this;
    }

    public Errors addMessage(ErrorMessage message) {
        if (this.errors == null) {
            this.errors = new ArrayList<ErrorMessage>();
        }
        this.errors.add(message);
        return this;
    }

    public Errors addMessage(String message, Object ... arguments) {
        return this.addMessage(null, message, arguments);
    }

    public Errors errorGettingValue(Member member, Throwable t) {
        return this.addMessage(t, "Failed to get value from %s", member);
    }

    public Errors errorInstantiatingDestination(Class<?> type, Throwable t) {
        return this.addMessage(t, "Failed to instantiate instance of destination %s. Ensure that %s has a non-private no-argument constructor.", type, type);
    }

    public Errors errorMapping(Object source, Class<?> destinationType) {
        return this.addMessage("Error mapping %s to %s", source, Types.toString(destinationType));
    }

    public Errors errorMapping(Object source, Type destinationType, Throwable t) {
        return this.addMessage(t, "Error mapping %s to %s", source, Types.toString(destinationType));
    }

    public Errors errorSettingValue(Member member, Object value, Throwable t) {
        return this.addMessage(t, "Failed to set value '%s' on %s", value, member);
    }

    public Errors errorTooLarge(Object source, Class<?> destinationType) {
        return this.addMessage("Value '%s' is too large for %s", source, Types.toString(destinationType));
    }

    public Errors errorTooSmall(Object source, Class<?> destinationType) {
        return this.addMessage("Value '%s' is too small for %s", source, Types.toString(destinationType));
    }

    public Errors errorUnmappedProperties(TypeMap<?, ?> typeMap, List<PropertyInfo> unmappedProperties) {
        return this.addMessage("Unmapped destination properties found in %s:\n\n%s", typeMap, unmappedProperties);
    }

    public Errors errorUnsupportedMapping(Class<?> sourceType, Class<?> destinationType) {
        return this.addMessage("Missing type map configuration or unsupported mapping for %s to %s.", sourceType, destinationType);
    }

    public List<ErrorMessage> getMessages() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    public Errors invalidProvidedDestinationInstance(Object destination, Class<?> requiredType) {
        return this.addMessage("The provided destination instance %s is not of the required type %s.", destination, requiredType);
    }

    public Errors merge(Collection<ErrorMessage> errorMessages) {
        for (ErrorMessage message : errorMessages) {
            this.addMessage(message);
        }
        return this;
    }

    public Errors merge(Errors errors) {
        for (ErrorMessage message : errors.getMessages()) {
            this.addMessage(message);
        }
        return this;
    }

    public void throwConfigurationExceptionIfErrorsExist() {
        if (this.hasErrors()) {
            throw new ConfigurationException(this.getMessages());
        }
    }

    public void throwValidationExceptionIfErrorsExist() {
        if (this.hasErrors()) {
            throw new ValidationException(this.getMessages());
        }
    }

    public ConfigurationException toConfigurationException() {
        return new ConfigurationException(this.getMessages());
    }

    public ErrorsException toException() {
        return new ErrorsException(this);
    }

    public MappingException toMappingException() {
        return new MappingException(this.getMessages());
    }

    Errors ambiguousDestination(List<? extends PropertyMapping> mappings) {
        ArrayList<String> sourcePropertyInfo = new ArrayList<String>();
        for (PropertyMapping propertyMapping : mappings) {
            sourcePropertyInfo.add(Strings.joinMembers(propertyMapping.getSourceProperties()));
        }
        return this.addMessage("The destination property %s matches multiple source property hierarchies:\n\n%s", Strings.joinMembers(mappings.get(0).getDestinationProperties()), sourcePropertyInfo);
    }

    Errors conditionalSkipWithoutSource() {
        return this.addMessage("A conditional skip can only be used with skip(Object, Object).", new Object[0]);
    }

    Errors duplicateMapping(PropertyInfo destinationProperty) {
        return this.addMessage("A mapping already exists for %s.", destinationProperty);
    }

    Errors errorAccessingConfigure(Throwable t) {
        return this.addMessage(t, "Failed to access PropertyMap.configure().", new Object[0]);
    }

    Errors errorAccessingProperty(PropertyInfo propertyInfo) {
        return this.addMessage("Failed to access %s.", propertyInfo);
    }

    Errors errorConverting(org.modelmapper.Converter<?, ?> converter, Class<?> sourceType, Class<?> destinationType, Throwable throwable) {
        return this.addMessage(throwable, "Converter %s failed to convert %s to %s.", converter, sourceType, destinationType);
    }

    Errors errorEnhancingClass(Class<?> type, Throwable t) {
        return this.addMessage(t, "Failed to generate proxy class for %s. Ensure that %s has a non-private constructor.", type, type);
    }

    Errors errorInstantiatingProxy(Class<?> type, Throwable t) {
        return this.addMessage(t, "Failed to instantiate proxied instance of %s. Ensure that %s has a non-private constructor.", type, type);
    }

    Errors errorResolvingClass(Throwable t, String className) {
        return this.addMessage("Error resolving class %s", className);
    }

    Errors errorReadingClass(Throwable t, String className) {
        return this.addMessage("Error reading class %s", className);
    }

    Errors errorInvalidSourcePath(String sourcePath, Class<?> unresolveableType, String unresolveableProperty) {
        return this.addMessage("The source path %s is invalid: %s.%s cannot be resolved.", sourcePath, unresolveableType, unresolveableProperty);
    }

    Errors errorNullArgument(String parameter) {
        return this.addMessage("The %s cannot be null", parameter);
    }

    Errors invalidDestinationMethod(Method method) {
        return this.addMessage("Invalid destination method %s. Ensure that method has one parameter and returns void.", method);
    }

    Errors invalidDestinationField(Field field) {
        return this.addMessage("Invalid destination field %s. Ensure that field is not static.", field);
    }

    Errors invalidSourceMethod(Method method) {
        return this.addMessage("Invalid source method %s. Ensure that method has zero parameters and does not return void.", method);
    }

    Errors invalidSourceField(Field field) {
        return this.addMessage("Invalid source field %s. Ensure that field is not static.", field);
    }

    Errors invocationAgainstFinalClass(Class<?> type) {
        return this.addMessage("Cannot map final type %s.", type);
    }

    Errors invocationAgainstFinalMethod(Member member) {
        return this.addMessage("Cannot map final method %s.", member);
    }

    Errors mappingForEnum() {
        return this.addMessage("Cannot create mapping for enum.", new Object[0]);
    }

    Errors missingDestination() {
        return this.addMessage("A mapping is missing a required destination member.", new Object[0]);
    }

    Errors missingMutatorForAccessor(Method method) {
        return this.addMessage("No corresponding mutator was found for %s.", method);
    }

    Errors missingSource() {
        return this.addMessage("A mapping is missing a required source member.", new Object[0]);
    }

    Errors sourceOutsideOfMap() {
        return this.addMessage("'source' cannot be used outside of a map statement.", new Object[0]);
    }

    void throwMappingExceptionIfErrorsExist() {
        if (this.hasErrors()) {
            throw new MappingException(this.getMessages());
        }
    }

    private static abstract class Converter<T> {
        final Class<T> type;

        Converter(Class<T> type) {
            this.type = type;
        }

        boolean appliesTo(Object subject) {
            return subject != null && this.type.isAssignableFrom(subject.getClass());
        }

        String convert(Object subject) {
            return this.toString(this.type.cast(subject));
        }

        abstract String toString(T var1);
    }
}

