/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.modelmapper.Condition;
import org.modelmapper.ConfigurationException;
import org.modelmapper.Converter;
import org.modelmapper.PropertyMap;
import org.modelmapper.Provider;
import org.modelmapper.builder.ConditionExpression;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.ConstantMappingImpl;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.ExplicitMappingVisitor;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.PropertyInfoRegistry;
import org.modelmapper.internal.PropertyMappingImpl;
import org.modelmapper.internal.ProxyFactory;
import org.modelmapper.internal.SourceMappingImpl;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.asm.ClassReader;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.Members;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyType;
import org.modelmapper.spi.ValueReader;

public class ExplicitMappingBuilder<S, D>
implements ConditionExpression<S, D> {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static Method PROPERTY_MAP_CONFIGURE = Members.methodFor(PropertyMap.class, "configure", ExplicitMappingBuilder.class);
    private final Class<S> sourceType;
    private final Class<D> destinationType;
    private final InheritingConfiguration configuration;
    public volatile S source;
    public volatile D destination;
    private final Errors proxyErrors = new Errors();
    private final Errors errors = new Errors();
    private List<ExplicitMappingVisitor.VisitedMapping> visitedMappings;
    private final Map<Object, ExplicitMappingInterceptor> proxyInterceptors = new IdentityHashMap<Object, ExplicitMappingInterceptor>();
    private final Set<MappingImpl> propertyMappings = new HashSet<MappingImpl>();
    private int currentMappingIndex;
    private ExplicitMappingVisitor.VisitedMapping currentMapping;
    private MappingOptions options = new MappingOptions();
    private List<Accessor> sourceAccessors;
    private Object sourceConstant;

    ExplicitMappingBuilder(Class<S> sourceType, Class<D> destinationType, InheritingConfiguration configuration) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.configuration = configuration;
    }

    @Override
    public D skip() {
        this.map();
        this.options.skipType = 1;
        return this.destination;
    }

    @Override
    public void skip(Object destination) {
        this.map(destination);
        this.options.skipType = 2;
    }

    @Override
    public void skip(Object source, Object destination) {
        this.map(source, destination);
        this.options.skipType = 3;
    }

    @Override
    public D map() {
        this.saveLastMapping();
        this.getNextMapping();
        return this.destination;
    }

    @Override
    public D map(Object subject) {
        this.saveLastMapping();
        this.getNextMapping();
        this.recordSourceValue(subject);
        return this.destination;
    }

    @Override
    public void map(Object source, Object destination) {
        this.saveLastMapping();
        this.getNextMapping();
        this.recordSourceValue(source);
    }

    public <T> T source(String sourcePropertyPath) {
        if (sourcePropertyPath == null) {
            this.errors.errorNullArgument("sourcePropertyPath");
        }
        if (this.sourceAccessors != null) {
            this.saveLastMapping();
        }
        String[] propertyNames = DOT_PATTERN.split(sourcePropertyPath);
        this.sourceAccessors = new ArrayList<Accessor>(propertyNames.length);
        ValueReader<S> valueReader = this.configuration.valueAccessStore.getFirstSupportedReader(this.sourceType);
        if (valueReader != null) {
            for (String propertyName : propertyNames) {
                this.sourceAccessors.add(new PropertyInfoImpl.ValueReaderPropertyInfo(valueReader, Object.class, propertyName));
            }
        } else {
            PropertyInfo accessor = null;
            for (String propertyName : propertyNames) {
                Class<Object> propertyType = accessor == null ? this.sourceType : accessor.getType();
                TypeInfoRegistry.typeInfoFor(propertyType, this.configuration).getAccessors();
                accessor = PropertyInfoRegistry.accessorFor(propertyType, propertyName, this.configuration);
                if (accessor == null) {
                    this.errors.errorInvalidSourcePath(sourcePropertyPath, propertyType, propertyName);
                    return null;
                }
                this.sourceAccessors.add((Accessor)accessor);
            }
        }
        return null;
    }

    public ConditionExpression<S, D> using(Converter<?, ?> converter) {
        this.saveLastMapping();
        if (converter == null) {
            this.errors.errorNullArgument("converter");
        }
        Assert.state(this.options.converter == null, "using() can only be called once per mapping.", new Object[0]);
        this.options.converter = converter;
        return this;
    }

    @Override
    public ConditionExpression<S, D> when(Condition<?, ?> condition) {
        this.saveLastMapping();
        if (condition == null) {
            this.errors.errorNullArgument("condition");
        }
        Assert.state(this.options.condition == null, "when() can only be called once per mapping.", new Object[0]);
        this.options.condition = condition;
        return this;
    }

    @Override
    public ConditionExpression<S, D> with(Provider<?> provider) {
        this.saveLastMapping();
        if (provider == null) {
            this.errors.errorNullArgument("provider");
        }
        Assert.state(this.options.provider == null, "withProvider() can only be called once per mapping.", new Object[0]);
        this.options.provider = provider;
        return this;
    }

    Collection<MappingImpl> build(PropertyMap<S, D> propertyMap) {
        try {
            PROPERTY_MAP_CONFIGURE.invoke(propertyMap, this);
            this.saveLastMapping();
        }
        catch (IllegalAccessException e) {
            this.errors.errorAccessingConfigure(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConfigurationException) {
                throw (ConfigurationException)cause;
            }
            this.errors.addMessage(cause, "Failed to configure mappings", new Object[0]);
        }
        catch (NullPointerException e) {
            if (this.proxyErrors.hasErrors()) {
                throw this.proxyErrors.toException();
            }
            throw e;
        }
        this.errors.throwConfigurationExceptionIfErrorsExist();
        return this.propertyMappings;
    }

    public void visitPropertyMap(PropertyMap<S, D> propertyMap) {
        String propertyMapClassName = propertyMap.getClass().getName();
        try {
            ClassReader cr = new ClassReader(propertyMap.getClass().getClassLoader().getResourceAsStream(propertyMapClassName.replace('.', '/') + ".class"));
            ExplicitMappingVisitor visitor = new ExplicitMappingVisitor(this.errors, this.configuration, propertyMapClassName, this.destinationType.getName(), propertyMap.getClass().getClassLoader());
            cr.accept(visitor, 6);
            this.visitedMappings = visitor.mappings;
        }
        catch (IOException e) {
            this.errors.errorReadingClass(e, propertyMapClassName);
        }
        this.validateVisitedMappings();
        this.errors.throwConfigurationExceptionIfErrorsExist();
        this.createProxies();
    }

    private void validateVisitedMappings() {
        for (ExplicitMappingVisitor.VisitedMapping mapping : this.visitedMappings) {
            if (!mapping.destinationMutators.isEmpty()) continue;
            this.errors.missingDestination();
        }
    }

    private void createProxies() {
        this.source = this.createProxy(this.sourceType);
        this.destination = this.createProxy(this.destinationType);
        for (ExplicitMappingVisitor.VisitedMapping mapping : this.visitedMappings) {
            this.createAccessorProxies(this.source, mapping.sourceAccessors);
            this.createAccessorProxies(this.destination, mapping.destinationAccessors);
        }
    }

    private void createAccessorProxies(Object proxy, List<Accessor> accessors) {
        for (Accessor accessor : accessors) {
            if (accessor instanceof PropertyInfoImpl.MethodAccessor) {
                ExplicitMappingInterceptor interceptor = this.proxyInterceptors.get(proxy);
                String methodName = accessor.getMember().getName();
                proxy = interceptor.methodProxies.get(methodName);
                if (proxy != null) continue;
                proxy = this.createProxy(accessor.getType());
                interceptor.methodProxies.put(methodName, proxy);
                continue;
            }
            if (!(accessor instanceof PropertyInfoImpl.FieldPropertyInfo)) continue;
            PropertyInfoImpl.FieldPropertyInfo field = (PropertyInfoImpl.FieldPropertyInfo)accessor;
            Object nextProxy = field.getValue(proxy);
            if (nextProxy == null) {
                nextProxy = this.createProxy(field.getType());
                field.setValue(proxy, nextProxy);
            }
            proxy = nextProxy;
        }
    }

    private <T> T createProxy(Class<T> type) {
        ExplicitMappingInterceptor interceptor = new ExplicitMappingInterceptor();
        try {
            T proxy = ProxyFactory.proxyFor(type, interceptor, this.proxyErrors, this.configuration.isUseOSGiClassLoaderBridging());
            this.proxyInterceptors.put(proxy, interceptor);
            return proxy;
        }
        catch (ErrorsException e) {
            return null;
        }
    }

    private void getNextMapping() {
        if (this.currentMappingIndex < this.visitedMappings.size()) {
            this.currentMapping = this.visitedMappings.get(this.currentMappingIndex++);
        }
    }

    private void recordSourceValue(Object sourceValue) {
        if (sourceValue != null) {
            if (sourceValue == this.source) {
                this.options.mapFromSource = true;
            } else if (!Types.isProxied(sourceValue.getClass())) {
                this.sourceConstant = sourceValue;
            }
        }
    }

    private void validateRecordedMapping() {
        if (this.options.skipType == 0 && (this.currentMapping.sourceAccessors == null || this.currentMapping.sourceAccessors.isEmpty()) && this.currentMapping.destinationMutators.get(this.currentMapping.destinationMutators.size() - 1).getPropertyType().equals((Object)PropertyType.FIELD) && this.options.converter == null && !this.options.mapFromSource && this.sourceConstant == null) {
            this.errors.missingSource();
        } else if (this.options.skipType == 2 && this.options.condition != null) {
            this.errors.conditionalSkipWithoutSource();
        }
    }

    private void saveLastMapping() {
        if (this.currentMapping != null) {
            try {
                if (this.currentMapping.sourceAccessors.isEmpty()) {
                    this.currentMapping.sourceAccessors = this.sourceAccessors;
                }
                this.validateRecordedMapping();
                MappingImpl mapping = this.options.mapFromSource ? new SourceMappingImpl(this.sourceType, this.currentMapping.destinationMutators, this.options) : (this.currentMapping.sourceAccessors == null ? new ConstantMappingImpl(this.sourceConstant, this.currentMapping.destinationMutators, this.options) : new PropertyMappingImpl(this.currentMapping.sourceAccessors, this.currentMapping.destinationMutators, this.options));
                if (!this.propertyMappings.add(mapping)) {
                    this.errors.duplicateMapping(mapping.getLastDestinationProperty());
                }
            }
            finally {
                this.currentMapping = null;
                this.options = new MappingOptions();
                this.sourceAccessors = null;
                this.sourceConstant = null;
            }
        }
    }

    static {
        PROPERTY_MAP_CONFIGURE.setAccessible(true);
    }

    public final class ExplicitMappingInterceptor
    implements InvocationHandler {
        private final Map<String, Object> methodProxies = new HashMap<String, Object>();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if (args.length == 1) {
                ExplicitMappingBuilder.this.sourceConstant = args[0];
                if (ExplicitMappingBuilder.this.sourceConstant != null && ExplicitMappingBuilder.this.sourceConstant == ExplicitMappingBuilder.this.source) {
                    ExplicitMappingBuilder.this.errors.missingSource();
                }
            }
            return this.methodProxies.get(method.getName());
        }
    }

    static class MappingOptions {
        Condition<?, ?> condition;
        Converter<?, ?> converter;
        Provider<?> provider;
        int skipType;
        boolean mapFromSource;

        MappingOptions() {
        }
    }
}

