/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modelmapper.Converter;
import org.modelmapper.TypeMap;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.PropertyMappingImpl;
import org.modelmapper.internal.PropertyNameInfoImpl;
import org.modelmapper.internal.TypeInfo;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.TypeMapImpl;
import org.modelmapper.internal.TypeMapStore;
import org.modelmapper.internal.converter.ConverterStore;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.Strings;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MatchingStrategy;
import org.modelmapper.spi.NameableType;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

class ImplicitMappingBuilder<S, D> {
    private final TypeMapImpl<S, D> typeMap;
    private final TypeInfo<S> sourceTypeInfo;
    private final TypeMapStore typeMapStore;
    private final InheritingConfiguration configuration;
    private final ConverterStore converterStore;
    private final MatchingStrategy matchingStrategy;
    private final Errors errors = new Errors();
    private final PropertyNameInfoImpl propertyNameInfo;
    private final Set<Class<?>> sourceTypes = new HashSet();
    private final Set<Class<?>> destinationTypes = new HashSet();
    private final List<PropertyMappingImpl> mappings = new ArrayList<PropertyMappingImpl>();
    private final List<PropertyMappingImpl> partiallyMatchedMappings = new ArrayList<PropertyMappingImpl>();
    private final Map<Accessor, PropertyMappingImpl> intermediateMappings = new HashMap<Accessor, PropertyMappingImpl>();
    private final List<MappingImpl> mergedMappings = new ArrayList<MappingImpl>();

    ImplicitMappingBuilder(S source, TypeMapImpl<S, D> typeMap, TypeMapStore typeMapStore, ConverterStore converterStore) {
        this.typeMap = typeMap;
        this.converterStore = converterStore;
        this.typeMapStore = typeMapStore;
        this.configuration = typeMap.configuration;
        this.sourceTypeInfo = TypeInfoRegistry.typeInfoFor(source, typeMap.getSourceType(), this.configuration);
        this.matchingStrategy = this.configuration.getMatchingStrategy();
        this.propertyNameInfo = new PropertyNameInfoImpl(typeMap.getSourceType(), this.configuration);
    }

    void build() {
        this.matchDestination(TypeInfoRegistry.typeInfoFor(this.typeMap.getDestinationType(), this.configuration));
    }

    private void matchDestination(TypeInfo<?> destinationTypeInfo) {
        this.destinationTypes.add(destinationTypeInfo.getType());
        for (Map.Entry<String, Mutator> entry : destinationTypeInfo.getMutators().entrySet()) {
            this.propertyNameInfo.pushDestination(entry.getKey(), entry.getValue());
            String destPath = Strings.join(this.propertyNameInfo.getDestinationProperties());
            Mutator mutator = entry.getValue();
            MappingImpl existingMapping = this.typeMap.mappingFor(destPath);
            if (existingMapping == null) {
                this.matchSource(this.sourceTypeInfo, mutator);
                this.propertyNameInfo.clearSource();
                this.sourceTypes.clear();
            }
            if (this.mappings.isEmpty()) {
                this.mappings.addAll(this.partiallyMatchedMappings);
            }
            if (!this.mappings.isEmpty()) {
                PropertyMappingImpl mapping = null;
                if (this.mappings.size() == 1) {
                    mapping = this.mappings.get(0);
                } else {
                    mapping = this.disambiguateMappings();
                    if (mapping == null && !this.configuration.isAmbiguityIgnored()) {
                        this.errors.ambiguousDestination(this.mappings);
                    }
                }
                if (mapping != null) {
                    this.typeMap.addMapping(mapping);
                    if (Iterables.isIterable(mapping.getLastDestinationProperty().getType())) {
                        for (PropertyInfo sourceAccessor : mapping.sourceAccessors) {
                            PropertyMappingImpl intermediateMapping = this.intermediateMappings.get(sourceAccessor);
                            if (intermediateMapping == null || intermediateMapping.getPath().equals(mapping.getPath())) continue;
                            this.typeMap.addMapping(intermediateMapping);
                        }
                    }
                }
                this.mappings.clear();
                this.partiallyMatchedMappings.clear();
                this.intermediateMappings.clear();
            } else if (!this.mergedMappings.isEmpty()) {
                for (MappingImpl mapping : this.mergedMappings) {
                    this.typeMap.addMapping(mapping);
                }
                this.mergedMappings.clear();
            } else if (!this.destinationTypes.contains(mutator.getType()) && !this.typeMap.isSkipped(destPath) && Types.mightContainsProperties(mutator.getType()) && !this.isConvertable(existingMapping)) {
                this.matchDestination(mutator.getTypeInfo(this.configuration));
            }
            this.propertyNameInfo.popDestination();
        }
        this.destinationTypes.remove(destinationTypeInfo.getType());
        this.errors.throwConfigurationExceptionIfErrorsExist();
    }

    private void matchSource(TypeInfo<?> sourceTypeInfo, Mutator destinationMutator) {
        this.sourceTypes.add(sourceTypeInfo.getType());
        for (Map.Entry<String, Accessor> entry : sourceTypeInfo.getAccessors().entrySet()) {
            Accessor accessor = entry.getValue();
            this.propertyNameInfo.pushSource(entry.getKey(), entry.getValue());
            boolean doneMatching = false;
            if (this.matchingStrategy.matches(this.propertyNameInfo)) {
                if (this.destinationTypes.contains(destinationMutator.getType())) {
                    this.mappings.add(new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), true));
                } else {
                    TypeMap<?, ?> propertyTypeMap = this.typeMapStore.get(accessor.getType(), destinationMutator.getType(), null);
                    PropertyMappingImpl mapping = null;
                    if (propertyTypeMap != null) {
                        Converter<?, ?> propertyConverter = propertyTypeMap.getConverter();
                        if (propertyConverter == null) {
                            this.mergeMappings(propertyTypeMap);
                        } else {
                            this.mappings.add(new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), propertyTypeMap.getProvider(), propertyConverter));
                        }
                        doneMatching = this.matchingStrategy.isExact();
                    } else {
                        for (ConditionalConverter<?, ?> converter : this.converterStore.getConverters()) {
                            ConditionalConverter.MatchResult matchResult = converter.match(accessor.getType(), destinationMutator.getType());
                            if (ConditionalConverter.MatchResult.NONE.equals((Object)matchResult)) continue;
                            mapping = new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), false);
                            if (ConditionalConverter.MatchResult.FULL.equals((Object)matchResult)) {
                                this.mappings.add(mapping);
                                doneMatching = this.matchingStrategy.isExact();
                                break;
                            }
                            if (this.configuration.isFullTypeMatchingRequired()) continue;
                            this.partiallyMatchedMappings.add(mapping);
                            break;
                        }
                    }
                    if (mapping == null) {
                        this.intermediateMappings.put(accessor, new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), false));
                    }
                }
            }
            if (!doneMatching && Types.mightContainsProperties(accessor.getType()) && (!this.sourceTypes.contains(accessor.getType()) || accessor instanceof PropertyInfoImpl.ValueReaderPropertyInfo)) {
                this.matchSource(accessor.getTypeInfo(this.configuration), destinationMutator);
            }
            this.propertyNameInfo.popSource();
            if (!doneMatching) continue;
            break;
        }
        this.sourceTypes.remove(sourceTypeInfo.getType());
    }

    PropertyMappingImpl disambiguateMappings() {
        double maxMatchRatio = -1.0;
        boolean multipleMax = false;
        PropertyMappingImpl closestMapping = null;
        for (PropertyMappingImpl mapping : this.mappings) {
            NameableType nameableType;
            double matches = 0.0;
            double totalSourceTokens = 0.0;
            double totalDestTokens = 0.0;
            String[][] allSourceTokens = new String[mapping.getSourceProperties().size()][];
            boolean[][] sourceMatches = new boolean[allSourceTokens.length][];
            for (int i = 0; i < mapping.getSourceProperties().size(); ++i) {
                PropertyInfo source = mapping.getSourceProperties().get(i);
                nameableType = NameableType.forPropertyType(source.getPropertyType());
                allSourceTokens[i] = this.configuration.getSourceNameTokenizer().tokenize(source.getName(), nameableType);
                sourceMatches[i] = new boolean[allSourceTokens[i].length];
                totalSourceTokens += (double)allSourceTokens[i].length;
            }
            for (int destIndex = 0; destIndex < mapping.getDestinationProperties().size(); ++destIndex) {
                PropertyInfo dest = mapping.getDestinationProperties().get(destIndex);
                nameableType = NameableType.forPropertyType(dest.getPropertyType());
                String[] destTokens = this.configuration.getDestinationNameTokenizer().tokenize(dest.getName(), nameableType);
                totalDestTokens += (double)destTokens.length;
                for (int destTokenIndex = 0; destTokenIndex < destTokens.length && matches < totalSourceTokens; ++destTokenIndex) {
                    String destToken = destTokens[destTokenIndex];
                    boolean matched = false;
                    for (int i = 0; i < allSourceTokens.length && !matched && matches < totalSourceTokens; ++i) {
                        String[] sourceTokens = allSourceTokens[i];
                        for (int j = 0; j < sourceTokens.length && !matched && matches < totalSourceTokens; ++j) {
                            if (sourceMatches[i][j] || !sourceTokens[j].equalsIgnoreCase(destToken)) continue;
                            matched = true;
                            matches += 1.0;
                            sourceMatches[i][j] = true;
                        }
                    }
                }
            }
            double matchRatio = matches / (totalSourceTokens + totalDestTokens);
            if (matchRatio == maxMatchRatio) {
                multipleMax = true;
            }
            if (!(matchRatio > maxMatchRatio)) continue;
            maxMatchRatio = matchRatio;
            closestMapping = mapping;
            multipleMax = false;
        }
        return multipleMax ? null : closestMapping;
    }

    private void mergeMappings(TypeMap<?, ?> destinationMap) {
        for (Mapping mapping : destinationMap.getMappings()) {
            this.mergedMappings.add(((MappingImpl)mapping).createMergedCopy(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties()));
        }
    }

    private boolean isConvertable(Mapping mapping) {
        if (mapping == null || mapping.getProvider() != null || !(mapping instanceof PropertyMapping)) {
            return false;
        }
        PropertyMapping propertyMapping = (PropertyMapping)mapping;
        boolean hasSupportConverter = this.converterStore.getFirstSupported(propertyMapping.getLastSourceProperty().getType(), mapping.getLastDestinationProperty().getType()) != null;
        boolean hasSupportTypeMap = this.typeMapStore.get(propertyMapping.getLastSourceProperty().getType(), mapping.getLastDestinationProperty().getType(), null) != null;
        return hasSupportConverter || hasSupportTypeMap;
    }
}

