/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.modelmapper.Provider;
import org.modelmapper.TypeMap;
import org.modelmapper.TypeToken;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.Primitives;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MappingContext;
import org.modelmapper.spi.MappingEngine;

public class MappingContextImpl<S, D>
implements MappingContext<S, D>,
Provider.ProvisionRequest<D> {
    final Map<String, Object> destinationCache;
    final Map<Object, Object> sourceToDestination;
    final List<Object> intermediateDestinations;
    final Errors errors;
    private final MappingContextImpl<?, ?> parent;
    private D destination;
    final String destinationPath;
    private final Class<D> destinationType;
    private final Type genericDestinationType;
    private final String typeMapName;
    final boolean providedDestination;
    private MappingImpl mapping;
    private final MappingEngine mappingEngine;
    private final S source;
    private final Class<S> sourceType;
    private Object parentSource;
    private TypeMap<S, D> typeMap;
    private final List<String> shadedPaths;

    public MappingContextImpl(S source, Class<S> sourceType, D destination, Class<D> destinationType, Type genericDestinationType, String typeMapName, MappingEngine mappingEngine) {
        this.parent = null;
        this.source = source;
        this.sourceType = sourceType;
        this.destination = destination;
        this.destinationPath = "";
        this.destinationType = destinationType;
        this.genericDestinationType = genericDestinationType == null ? destinationType : genericDestinationType;
        this.typeMapName = typeMapName;
        this.providedDestination = destination != null;
        this.mappingEngine = mappingEngine;
        this.errors = new Errors();
        this.destinationCache = new HashMap<String, Object>();
        this.shadedPaths = new ArrayList<String>();
        this.sourceToDestination = new IdentityHashMap<Object, Object>();
        this.intermediateDestinations = new ArrayList<Object>();
    }

    MappingContextImpl(MappingContextImpl<?, ?> context, S source, Class<S> sourceType, D destination, Class<D> destinationType, Type genericDestinationType, MappingImpl mapping, boolean inheritValues) {
        this.parent = context;
        this.source = source;
        this.sourceType = sourceType;
        this.destination = destination;
        this.destinationPath = mapping == null ? context.destinationPath : context.destinationPath + mapping.getPath();
        this.destinationType = destinationType;
        this.genericDestinationType = genericDestinationType == null ? destinationType : genericDestinationType;
        this.providedDestination = context.providedDestination;
        this.typeMap = null;
        this.typeMapName = null;
        this.mapping = mapping;
        this.parentSource = context.parentSource;
        this.mappingEngine = context.mappingEngine;
        this.errors = context.errors;
        this.destinationCache = inheritValues ? context.destinationCache : new HashMap<String, Object>();
        this.shadedPaths = inheritValues ? context.shadedPaths : new ArrayList<String>();
        this.sourceToDestination = context.sourceToDestination;
        this.intermediateDestinations = new ArrayList<Object>();
    }

    @Override
    public <CS, CD> MappingContext<CS, CD> create(CS source, CD destination) {
        Assert.notNull(source, "source");
        Assert.notNull(destination, "destination");
        return new MappingContextImpl<CS, CD>(this, source, Types.deProxy(source.getClass()), destination, Types.deProxy(destination.getClass()), null, this.mapping, false);
    }

    @Override
    public <CS, CD> MappingContext<CS, CD> create(CS source, Class<CD> destinationType) {
        Assert.notNull(source, "source");
        Assert.notNull(destinationType, "destinationType");
        return new MappingContextImpl<CS, Object>(this, source, Types.deProxy(source.getClass()), null, destinationType, null, null, false);
    }

    @Override
    public <CS, CD> MappingContext<CS, CD> create(CS source, Type destinationType) {
        Assert.notNull(source, "source");
        Assert.notNull(destinationType, "destinationType");
        TypeToken destinationTypeToken = TypeToken.of(destinationType);
        return new MappingContextImpl<CS, Object>(this, source, Types.deProxy(source.getClass()), null, destinationTypeToken.getRawType(), destinationTypeToken.getType(), this.mapping, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MappingContextImpl other = (MappingContextImpl)obj;
        if (!this.source.equals(other.source)) {
            return false;
        }
        if (!this.sourceType.equals(other.sourceType)) {
            return false;
        }
        return this.destinationType.equals(other.destinationType);
    }

    @Override
    public D getDestination() {
        return this.destination;
    }

    @Override
    public Class<D> getDestinationType() {
        return this.destinationType;
    }

    @Override
    public Type getGenericDestinationType() {
        return this.genericDestinationType;
    }

    @Override
    public Mapping getMapping() {
        return this.mapping;
    }

    @Override
    public MappingEngine getMappingEngine() {
        return this.mappingEngine;
    }

    @Override
    public MappingContext<?, ?> getParent() {
        return this.parent;
    }

    @Override
    public Class<D> getRequestedType() {
        return this.destinationType;
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public Class<S> getSourceType() {
        return this.sourceType;
    }

    @Override
    public TypeMap<S, D> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public String getTypeMapName() {
        return this.typeMapName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.sourceType.hashCode();
        result = 31 * result + this.destinationType.hashCode();
        return result;
    }

    public String toString() {
        return String.format("MappingContext[%s -> %s]", this.sourceType.getSimpleName(), this.destinationType.getSimpleName());
    }

    D destinationForSource() {
        return (D)this.sourceToDestination.get(this.source);
    }

    boolean isShaded(String subpath) {
        for (String shadedPath : this.shadedPaths) {
            if (!subpath.startsWith(shadedPath)) continue;
            return true;
        }
        return false;
    }

    Object parentSource() {
        return this.parentSource;
    }

    TypeMap<?, ?> parentTypeMap() {
        return this.parent == null ? null : this.parent.typeMap;
    }

    void setDestination(D destination, boolean trackForSource) {
        this.destination = destination;
        if (trackForSource && !Primitives.isPrimitiveWrapper(this.sourceType)) {
            this.sourceToDestination.put(this.source, destination);
        }
    }

    void setParentSource(Object parentSource) {
        this.parentSource = parentSource;
    }

    void setTypeMap(TypeMap<S, D> typeMap) {
        this.typeMap = typeMap;
    }

    void shadePath(String path) {
        this.shadedPaths.add(path);
    }
}

