/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.RawBsonDocument;
import org.bson.codecs.Decoder;

final class ChangeStreamBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private final ReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private AggregateResponseBatchCursor<RawBsonDocument> wrapped;
    private BsonDocument resumeToken;
    private final AtomicBoolean closed;

    ChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AggregateResponseBatchCursor<RawBsonDocument> wrapped, ReadBinding binding, BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.binding = binding.retain();
        this.wrapped = wrapped;
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.closed = new AtomicBoolean();
    }

    AggregateResponseBatchCursor<RawBsonDocument> getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean hasNext() {
        return this.resumeableOperation(new Function<AggregateResponseBatchCursor<RawBsonDocument>, Boolean>(){

            @Override
            public Boolean apply(AggregateResponseBatchCursor<RawBsonDocument> queryBatchCursor) {
                try {
                    Boolean bl = queryBatchCursor.hasNext();
                    return bl;
                }
                finally {
                    ChangeStreamBatchCursor.this.cachePostBatchResumeToken(queryBatchCursor);
                }
            }
        });
    }

    @Override
    public List<T> next() {
        return (List)this.resumeableOperation(new Function<AggregateResponseBatchCursor<RawBsonDocument>, List<T>>(){

            @Override
            public List<T> apply(AggregateResponseBatchCursor<RawBsonDocument> queryBatchCursor) {
                try {
                    List list = ChangeStreamBatchCursor.convertAndProduceLastId((List<RawBsonDocument>)queryBatchCursor.next(), ChangeStreamBatchCursor.this.changeStreamOperation.getDecoder(), lastId -> ChangeStreamBatchCursor.this.resumeToken = lastId);
                    return list;
                }
                finally {
                    ChangeStreamBatchCursor.this.cachePostBatchResumeToken(queryBatchCursor);
                }
            }
        });
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public List<T> tryNext() {
        return (List)this.resumeableOperation(new Function<AggregateResponseBatchCursor<RawBsonDocument>, List<T>>(){

            @Override
            public List<T> apply(AggregateResponseBatchCursor<RawBsonDocument> queryBatchCursor) {
                try {
                    List list = ChangeStreamBatchCursor.convertAndProduceLastId(queryBatchCursor.tryNext(), ChangeStreamBatchCursor.this.changeStreamOperation.getDecoder(), lastId -> ChangeStreamBatchCursor.this.resumeToken = lastId);
                    return list;
                }
                finally {
                    ChangeStreamBatchCursor.this.cachePostBatchResumeToken(queryBatchCursor);
                }
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.wrapped.close();
            this.binding.release();
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.wrapped.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.wrapped.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.wrapped.isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AggregateResponseBatchCursor<RawBsonDocument> queryBatchCursor) {
        if (queryBatchCursor.getPostBatchResumeToken() != null) {
            this.resumeToken = queryBatchCursor.getPostBatchResumeToken();
        }
    }

    @Nullable
    static <T> List<T> convertAndProduceLastId(@Nullable List<RawBsonDocument> rawDocuments, Decoder<T> decoder, Consumer<BsonDocument> lastIdConsumer) {
        ArrayList<Object> results = null;
        if (rawDocuments != null) {
            results = new ArrayList<Object>();
            for (RawBsonDocument rawDocument : rawDocuments) {
                if (!rawDocument.containsKey((Object)"_id")) {
                    throw new MongoChangeStreamException("Cannot provide resume functionality when the resume token is missing.");
                }
                results.add(rawDocument.decode(decoder));
            }
            lastIdConsumer.accept(rawDocuments.get(rawDocuments.size() - 1).getDocument((Object)"_id"));
        }
        return results;
    }

    <R> R resumeableOperation(Function<AggregateResponseBatchCursor<RawBsonDocument>, R> function) {
        while (true) {
            try {
                return function.apply(this.wrapped);
            }
            catch (Throwable t) {
                if (!ChangeStreamBatchCursorHelper.isResumableError(t, this.maxWireVersion)) {
                    throw MongoException.fromThrowableNonNull(t);
                }
                this.wrapped.close();
                OperationHelper.withReadConnectionSource(this.binding, new OperationHelper.CallableWithSource<Void>(){

                    @Override
                    public Void call(ConnectionSource source) {
                        ChangeStreamBatchCursor.this.changeStreamOperation.setChangeStreamOptionsForResume(ChangeStreamBatchCursor.this.resumeToken, source.getServerDescription().getMaxWireVersion());
                        return null;
                    }
                });
                this.wrapped = ((ChangeStreamBatchCursor)this.changeStreamOperation.execute(this.binding)).getWrapped();
                this.binding.release();
                continue;
            }
            break;
        }
    }
}

