/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Rule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.server.HTTP;
import org.neo4j.test.server.SharedServerTestBase;

public class AbstractRestFunctionalTestBase
extends SharedServerTestBase
implements GraphHolder {
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this, (boolean)true));
    @Rule
    public TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);

    @SafeVarargs
    public final String doCypherRestCall(String endpoint, String scriptTemplate, Response.Status status, Pair<String, String> ... params) {
        String parameterString = this.createParameterString(params);
        return this.doCypherRestCall(endpoint, scriptTemplate, status, parameterString);
    }

    public String doCypherRestCall(String endpoint, String scriptTemplate, Response.Status status, String parameterString) {
        this.data.get();
        String script = this.createScript(scriptTemplate);
        String queryString = "{\"query\": \"" + script + "\",\"params\":{" + parameterString + "}}";
        this.gen().expectedStatus(status.getStatusCode()).payload(queryString);
        return this.gen().post(endpoint).entity();
    }

    private Long idFor(String name) {
        return ((Node)((Map)this.data.get()).get(name)).getId();
    }

    private String createParameterString(Pair<String, String>[] params) {
        String paramString = "";
        for (Pair<String, String> param : params) {
            String delimiter = paramString.isEmpty() || paramString.endsWith("{") ? "" : ",";
            paramString = paramString + delimiter + "\"" + (String)param.first() + "\":\"" + (String)param.other() + "\"";
        }
        return paramString;
    }

    protected String createScript(String template) {
        for (String key : ((Map)this.data.get()).keySet()) {
            template = template.replace("%" + key + "%", this.idFor(key).toString());
        }
        return template;
    }

    public GraphDatabaseService graphdb() {
        return AbstractRestFunctionalTestBase.server().getDatabase().getGraph();
    }

    public <T> T resolveDependency(Class<T> cls) {
        return (T)((GraphDatabaseAPI)this.graphdb()).getDependencyResolver().resolveDependency(cls);
    }

    protected static String getDataUri() {
        return "http://localhost:" + AbstractRestFunctionalTestBase.getLocalHttpPort() + "/db/data/";
    }

    protected String getDatabaseUri() {
        return "http://localhost:" + AbstractRestFunctionalTestBase.getLocalHttpPort() + "/db/";
    }

    protected String getNodeUri(Node node) {
        return this.getNodeUri(node.getId());
    }

    protected String getNodeUri(long node) {
        return AbstractRestFunctionalTestBase.getDataUri() + "node" + "/" + node;
    }

    protected String getRelationshipUri(Relationship relationship) {
        return AbstractRestFunctionalTestBase.getDataUri() + "relationship" + "/" + relationship.getId();
    }

    protected String postNodeIndexUri(String indexName) {
        return AbstractRestFunctionalTestBase.getDataUri() + "index/node" + "/" + indexName;
    }

    protected String postRelationshipIndexUri(String indexName) {
        return AbstractRestFunctionalTestBase.getDataUri() + "index/relationship" + "/" + indexName;
    }

    protected String txUri() {
        return AbstractRestFunctionalTestBase.getDataUri() + "transaction";
    }

    protected static String txCommitUri() {
        return AbstractRestFunctionalTestBase.getDataUri() + "transaction/commit";
    }

    protected String txUri(long txId) {
        return AbstractRestFunctionalTestBase.getDataUri() + "transaction/" + txId;
    }

    public static long extractTxId(HTTP.Response response) {
        int lastSlash = response.location().lastIndexOf(47);
        String txIdString = response.location().substring(lastSlash + 1);
        return Long.parseLong(txIdString);
    }

    protected Node getNode(String name) {
        return (Node)((Map)this.data.get()).get(name);
    }

    protected Node[] getNodes(String ... names) {
        Node[] nodes = new Node[]{};
        ArrayList<Node> result = new ArrayList<Node>();
        for (String name : names) {
            result.add(this.getNode(name));
        }
        return result.toArray(nodes);
    }

    public void assertSize(int expectedSize, String entity) {
        try {
            Collection hits = (Collection)JsonHelper.readJson((String)entity);
            Assert.assertEquals((long)expectedSize, (long)hits.size());
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPropertiesUri(Relationship rel) {
        return this.getRelationshipUri(rel) + "/properties";
    }

    public String getPropertiesUri(Node node) {
        return this.getNodeUri(node) + "/properties";
    }

    public RESTRequestGenerator gen() {
        return (RESTRequestGenerator)this.gen.get();
    }

    public String getLabelsUri() {
        return String.format("%slabels", AbstractRestFunctionalTestBase.getDataUri());
    }

    public String getPropertyKeysUri() {
        return String.format("%spropertykeys", AbstractRestFunctionalTestBase.getDataUri());
    }

    public String getNodesWithLabelUri(String label) {
        return String.format("%slabel/%s/nodes", AbstractRestFunctionalTestBase.getDataUri(), label);
    }

    public String getNodesWithLabelAndPropertyUri(String label, String property, Object value) throws UnsupportedEncodingException {
        return String.format("%slabel/%s/nodes?%s=%s", AbstractRestFunctionalTestBase.getDataUri(), label, property, URLEncoder.encode(JsonHelper.createJsonFrom((Object)value), StandardCharsets.UTF_8.name()));
    }

    public String getSchemaIndexUri() {
        return AbstractRestFunctionalTestBase.getDataUri() + "schema/index";
    }

    public String getSchemaIndexLabelUri(String label) {
        return AbstractRestFunctionalTestBase.getDataUri() + "schema/index" + "/" + label;
    }

    public String getSchemaIndexLabelPropertyUri(String label, String property) {
        return AbstractRestFunctionalTestBase.getDataUri() + "schema/index" + "/" + label + "/" + property;
    }

    public String getSchemaConstraintUri() {
        return AbstractRestFunctionalTestBase.getDataUri() + "schema/constraint";
    }

    public String getSchemaConstraintLabelUri(String label) {
        return AbstractRestFunctionalTestBase.getDataUri() + "schema/constraint" + "/" + label;
    }

    public String getSchemaConstraintLabelUniquenessUri(String label) {
        return AbstractRestFunctionalTestBase.getDataUri() + "schema/constraint" + "/" + label + "/uniqueness/";
    }

    public String getSchemaConstraintLabelUniquenessPropertyUri(String label, String property) {
        return AbstractRestFunctionalTestBase.getDataUri() + "schema/constraint" + "/" + label + "/uniqueness/" + property;
    }

    public static int getLocalHttpPort() {
        ConnectorPortRegister connectorPortRegister = (ConnectorPortRegister)AbstractRestFunctionalTestBase.server().getDatabase().getGraph().getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return connectorPortRegister.getLocalAddress("http").getPort();
    }

    public static HTTP.Response runQuery(String query) {
        return HTTP.POST(AbstractRestFunctionalTestBase.txCommitUri(), HTTP.RawPayload.quotedJson("{'statements': [{'statement': '" + query + "'}]}"));
    }

    public static void assertNoErrors(HTTP.Response response) throws JsonParseException {
        Assert.assertEquals((Object)"[]", (Object)response.get("errors").toString());
        Assert.assertEquals((long)0L, (long)response.get("errors").size());
    }
}

