/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;
import org.neo4j.test.Property;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Properties;

public class NodeRepresentationTest {
    @Test
    public void shouldHaveSelfLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern(""), this.noderep(1234L).selfUri());
    }

    @Test
    public void shouldHaveAllRelationshipsLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all"), this.noderep(1234L).allRelationshipsUri());
    }

    @Test
    public void shouldHaveIncomingRelationshipsLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in"), this.noderep(1234L).incomingRelationshipsUri());
    }

    @Test
    public void shouldHaveOutgoingRelationshipsLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out"), this.noderep(1234L).outgoingRelationshipsUri());
    }

    @Test
    public void shouldHaveAllTypedRelationshipsLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all/\\{-list\\|&\\|types\\}"), this.noderep(1234L).allTypedRelationshipsUriTemplate());
    }

    @Test
    public void shouldHaveIncomingTypedRelationshipsLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in/\\{-list\\|&\\|types\\}"), this.noderep(1234L).incomingTypedRelationshipsUriTemplate());
    }

    @Test
    public void shouldHaveOutgoingTypedRelationshipsLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out/\\{-list\\|&\\|types\\}"), this.noderep(1234L).outgoingTypedRelationshipsUriTemplate());
    }

    @Test
    public void shouldHaveRelationshipCreationLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships"), this.noderep(1234L).relationshipCreationUri());
    }

    @Test
    public void shouldHavePropertiesLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties"), this.noderep(1234L).propertiesUri());
    }

    @Test
    public void shouldHavePropertyLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties/\\{key\\}"), this.noderep(1234L).propertyUriTemplate());
    }

    @Test
    public void shouldHaveTraverseLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/traverse/\\{returnType\\}"), this.noderep(1234L).traverseUriTemplate());
    }

    @Test
    public void shouldSerialiseToMap() {
        Map<String, Object> repr = RepresentationTestAccess.serialize((MappingRepresentation)this.noderep(1234L));
        Assert.assertNotNull(repr);
        NodeRepresentationTest.verifySerialisation(repr);
    }

    @Test
    public void shouldHaveLabelsLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/labels"), this.noderep(1234L).labelsUriTemplate());
    }

    private NodeRepresentation noderep(long id) {
        return new NodeRepresentation(GraphMock.node((long)id, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[]{"Label"}));
    }

    public static void verifySerialisation(Map<String, Object> noderep) {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern(""), noderep.get("self").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships"), noderep.get("create_relationship").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all"), noderep.get("all_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in"), noderep.get("incoming_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out"), noderep.get("outgoing_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all/\\{-list\\|&\\|types\\}"), (String)noderep.get("all_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in/\\{-list\\|&\\|types\\}"), (String)noderep.get("incoming_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out/\\{-list\\|&\\|types\\}"), (String)noderep.get("outgoing_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties"), noderep.get("properties").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties/\\{key\\}"), (String)noderep.get("property"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/traverse/\\{returnType\\}"), (String)noderep.get("traverse"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/labels"), (String)noderep.get("labels"));
        Assert.assertNotNull((Object)noderep.get("data"));
        Map metadata = (Map)noderep.get("metadata");
        List labels = (List)metadata.get("labels");
        Assert.assertTrue((labels.isEmpty() || labels.equals(Arrays.asList("Label")) ? 1 : 0) != 0);
        Assert.assertTrue((((Number)metadata.get("id")).longValue() >= 0L ? 1 : 0) != 0);
    }
}

