/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.time.Clock;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class BackupModule {
    private final OutsideWorld outsideWorld;
    private final LogProvider logProvider;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final Monitors monitors;
    private final Clock clock;
    private final TransactionLogCatchUpFactory transactionLogCatchUpFactory;

    BackupModule(OutsideWorld outsideWorld, LogProvider logProvider, Monitors monitors) {
        this.outsideWorld = outsideWorld;
        this.logProvider = logProvider;
        this.monitors = monitors;
        this.clock = Clock.systemDefaultZone();
        this.transactionLogCatchUpFactory = new TransactionLogCatchUpFactory();
        this.fileSystemAbstraction = outsideWorld.fileSystem();
    }

    public LogProvider getLogProvider() {
        return this.logProvider;
    }

    public FileSystemAbstraction getFileSystemAbstraction() {
        return this.fileSystemAbstraction;
    }

    public Monitors getMonitors() {
        return this.monitors;
    }

    public Clock getClock() {
        return this.clock;
    }

    public TransactionLogCatchUpFactory getTransactionLogCatchUpFactory() {
        return this.transactionLogCatchUpFactory;
    }

    public OutsideWorld getOutsideWorld() {
        return this.outsideWorld;
    }
}

