/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.nio.file.Path;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;

class OnlineBackupRequiredArguments {
    private final OptionalHostnamePort address;
    private final Path directory;
    private final String name;
    private final boolean fallbackToFull;
    private final boolean doConsistencyCheck;
    private final long timeout;
    private final Path reportDir;
    private final SelectedBackupProtocol selectedBackupProtocol;

    OnlineBackupRequiredArguments(OptionalHostnamePort address, Path directory, String name, SelectedBackupProtocol selectedBackupProtocol, boolean fallbackToFull, boolean doConsistencyCheck, long timeout, Path reportDir) {
        this.address = address;
        this.directory = directory;
        this.name = name;
        this.fallbackToFull = fallbackToFull;
        this.doConsistencyCheck = doConsistencyCheck;
        this.timeout = timeout;
        this.reportDir = reportDir;
        this.selectedBackupProtocol = selectedBackupProtocol;
    }

    public OptionalHostnamePort getAddress() {
        return this.address;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFallbackToFull() {
        return this.fallbackToFull;
    }

    public boolean isDoConsistencyCheck() {
        return this.doConsistencyCheck;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Path getReportDir() {
        return this.reportDir;
    }

    public Path getResolvedLocationFromName() {
        return this.directory.resolve(this.name);
    }

    public SelectedBackupProtocol getSelectedBackupProtocol() {
        return this.selectedBackupProtocol;
    }
}

