/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.neo4j.backup.impl.BackupStrategyWrapper;
import org.neo4j.backup.impl.SelectedBackupProtocol;

class StrategyResolverService {
    private final BackupStrategyWrapper haBackupStrategy;
    private final BackupStrategyWrapper ccBackupStrategy;

    StrategyResolverService(BackupStrategyWrapper haBackupStrategy, BackupStrategyWrapper ccBackupStrategy) {
        this.haBackupStrategy = haBackupStrategy;
        this.ccBackupStrategy = ccBackupStrategy;
    }

    List<BackupStrategyWrapper> getStrategies(SelectedBackupProtocol selectedBackupProtocol) {
        switch (selectedBackupProtocol) {
            case ANY: {
                return Arrays.asList(this.ccBackupStrategy, this.haBackupStrategy);
            }
            case COMMON: {
                return Collections.singletonList(this.haBackupStrategy);
            }
            case CATCHUP: {
                return Collections.singletonList(this.ccBackupStrategy);
            }
        }
        throw new IllegalArgumentException("Unhandled protocol choice: " + (Object)((Object)selectedBackupProtocol));
    }
}

