/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyFiles;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileIndexListing;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.rule.TestDirectory;

public class PrepareStoreCopyFilesTest {
    private final FileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fileSystemAbstraction);
    private PrepareStoreCopyFiles prepareStoreCopyFiles;
    private PageCache pageCache;
    private NeoStoreFileIndexListing indexListingMock;
    private File storeDir;
    private NeoStoreFileListing.StoreFileListingBuilder fileListingBuilder;

    @Before
    public void setUp() {
        this.pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fileSystemAbstraction);
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        this.fileListingBuilder = (NeoStoreFileListing.StoreFileListingBuilder)Mockito.mock(NeoStoreFileListing.StoreFileListingBuilder.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.storeDir = this.testDirectory.graphDbDir();
        Mockito.when((Object)dataSource.getStoreDir()).thenReturn((Object)this.storeDir);
        this.indexListingMock = (NeoStoreFileIndexListing)Mockito.mock(NeoStoreFileIndexListing.class);
        Mockito.when((Object)this.indexListingMock.getIndexIds()).thenReturn((Object)Primitive.longSet());
        NeoStoreFileListing storeFileListing = (NeoStoreFileListing)Mockito.mock(NeoStoreFileListing.class);
        Mockito.when((Object)storeFileListing.getNeoStoreFileIndexListing()).thenReturn((Object)this.indexListingMock);
        Mockito.when((Object)storeFileListing.builder()).thenReturn((Object)this.fileListingBuilder);
        Mockito.when((Object)dataSource.getNeoStoreFileListing()).thenReturn((Object)storeFileListing);
        this.prepareStoreCopyFiles = new PrepareStoreCopyFiles(dataSource, this.pageCache, this.fileSystemAbstraction);
    }

    @Test
    public void shouldHanldeEmptyListOfFilesForeEachType() throws Exception {
        this.setExpectedFiles(new StoreFileMetadata[0]);
        File[] files = this.prepareStoreCopyFiles.listReplayableFiles();
        StoreResource[] atomicFilesSnapshot = this.prepareStoreCopyFiles.getAtomicFilesSnapshot();
        Assert.assertEquals((long)0L, (long)files.length);
        Assert.assertEquals((long)0L, (long)atomicFilesSnapshot.length);
    }

    private void setExpectedFiles(StoreFileMetadata[] expectedFiles) throws IOException {
        ((NeoStoreFileListing.StoreFileListingBuilder)Mockito.doAnswer(invocation -> Iterators.asResourceIterator((Iterator)Iterators.iterator((Object[])expectedFiles))).when((Object)this.fileListingBuilder)).build();
    }

    @Test
    public void shouldReturnExpectedListOfFileNamesForEachType() throws Exception {
        StoreFileMetadata[] expectedFiles = new StoreFileMetadata[]{new StoreFileMetadata(new File(this.storeDir, "a"), 1), new StoreFileMetadata(new File(this.storeDir, "b"), 2)};
        this.setExpectedFiles(expectedFiles);
        Object[] files = this.prepareStoreCopyFiles.listReplayableFiles();
        StoreResource[] atomicFilesSnapshot = this.prepareStoreCopyFiles.getAtomicFilesSnapshot();
        Object[] expectedFilesConverted = (File[])Arrays.stream(expectedFiles).map(StoreFileMetadata::file).toArray(File[]::new);
        StoreResource[] exeptedAtomicFilesConverted = (StoreResource[])Arrays.stream(expectedFiles).map(f -> new StoreResource(f.file(), this.getRelativePath((StoreFileMetadata)f), f.recordSize(), this.pageCache, this.fileSystemAbstraction)).toArray(StoreResource[]::new);
        Assert.assertArrayEquals((Object[])expectedFilesConverted, (Object[])files);
        Assert.assertEquals((long)exeptedAtomicFilesConverted.length, (long)atomicFilesSnapshot.length);
        for (int i = 0; i < exeptedAtomicFilesConverted.length; ++i) {
            StoreResource expected = exeptedAtomicFilesConverted[i];
            StoreResource storeResource = atomicFilesSnapshot[i];
            Assert.assertEquals((Object)expected.path(), (Object)storeResource.path());
            Assert.assertEquals((long)expected.recordSize(), (long)storeResource.recordSize());
        }
    }

    @Test
    public void shouldHandleEmptyDescriptors() {
        PrimitiveLongSet indexIds = this.prepareStoreCopyFiles.getNonAtomicIndexIds();
        Assert.assertEquals((long)0L, (long)indexIds.size());
    }

    @Test
    public void shouldReturnEmptySetOfIdsAndIgnoreIndexListing() {
        PrimitiveLongSet existingIds = Primitive.longSet();
        existingIds.add(42L);
        Mockito.when((Object)this.indexListingMock.getIndexIds()).thenReturn((Object)existingIds);
        PrimitiveLongSet actualIndexIndexIds = this.prepareStoreCopyFiles.getNonAtomicIndexIds();
        Assert.assertTrue((boolean)actualIndexIndexIds.isEmpty());
    }

    private String getRelativePath(StoreFileMetadata f) {
        try {
            return FileUtils.relativePath((File)this.storeDir, (File)f.file());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create relative path");
        }
    }
}

