/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchUpResponseCallback;
import org.neo4j.causalclustering.catchup.storecopy.GetIndexFilesRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyResponseAdaptors;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamProvider;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDiskProvider;
import org.neo4j.causalclustering.catchup.storecopy.TestCatchupServer;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.CatchUpRequest;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class SimpleCatchupClient
implements AutoCloseable {
    private final GraphDatabaseAPI graphDb;
    private final FileSystemAbstraction fsa;
    private final CatchUpClient catchUpClient;
    private final TestCatchupServer catchupServer;
    private final AdvertisedSocketAddress from;
    private final StoreId correctStoreId;
    private final StreamToDiskProvider streamToDiskProvider;
    private final PageCache clientPageCache;
    private final Log log;
    private final LogProvider logProvider;

    SimpleCatchupClient(GraphDatabaseAPI graphDb, FileSystemAbstraction fileSystemAbstraction, CatchUpClient catchUpClient, TestCatchupServer catchupServer, File temporaryDirectory, LogProvider logProvider) {
        this.graphDb = graphDb;
        this.fsa = fileSystemAbstraction;
        this.catchUpClient = catchUpClient;
        this.catchupServer = catchupServer;
        this.from = this.getCatchupServerAddress();
        this.correctStoreId = this.getStoreIdFromKernelStoreId(graphDb);
        this.clientPageCache = this.createPageCache();
        this.streamToDiskProvider = new StreamToDiskProvider(temporaryDirectory, this.fsa, this.clientPageCache, new Monitors());
        this.log = logProvider.getLog(SimpleCatchupClient.class);
        this.logProvider = logProvider;
    }

    private PageCache createPageCache() {
        return StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fsa);
    }

    PrepareStoreCopyResponse requestListOfFilesFromServer() throws CatchUpClientException {
        return this.requestListOfFilesFromServer(this.correctStoreId);
    }

    PrepareStoreCopyResponse requestListOfFilesFromServer(StoreId expectedStoreId) throws CatchUpClientException {
        return (PrepareStoreCopyResponse)this.catchUpClient.makeBlockingRequest(this.from, (CatchUpRequest)new PrepareStoreCopyRequest(expectedStoreId), (CatchUpResponseCallback)StoreCopyResponseAdaptors.prepareStoreCopyAdaptor((StoreFileStreamProvider)this.streamToDiskProvider, (Log)this.logProvider.getLog(SimpleCatchupClient.class)));
    }

    StoreCopyFinishedResponse requestIndividualFile(File file) throws CatchUpClientException {
        return this.requestIndividualFile(file, this.correctStoreId);
    }

    StoreCopyFinishedResponse requestIndividualFile(File file, StoreId expectedStoreId) throws CatchUpClientException {
        long lastTransactionId = SimpleCatchupClient.getCheckPointer(this.graphDb).lastCheckPointedTransactionId();
        GetStoreFileRequest storeFileRequest = new GetStoreFileRequest(expectedStoreId, file, lastTransactionId);
        return (StoreCopyFinishedResponse)this.catchUpClient.makeBlockingRequest(this.from, (CatchUpRequest)storeFileRequest, (CatchUpResponseCallback)StoreCopyResponseAdaptors.filesCopyAdaptor((StoreFileStreamProvider)this.streamToDiskProvider, (Log)this.log));
    }

    private StoreId getStoreIdFromKernelStoreId(GraphDatabaseAPI graphDb) {
        org.neo4j.kernel.impl.store.StoreId storeId = graphDb.storeId();
        return new StoreId(storeId.getCreationTime(), storeId.getRandomId(), storeId.getUpgradeTime(), storeId.getUpgradeId());
    }

    private AdvertisedSocketAddress getCatchupServerAddress() {
        return new AdvertisedSocketAddress("localhost", this.catchupServer.address().getPort());
    }

    StoreCopyFinishedResponse requestIndexSnapshot(long indexId) throws CatchUpClientException {
        long lastCheckPointedTransactionId = SimpleCatchupClient.getCheckPointer(this.graphDb).lastCheckPointedTransactionId();
        StoreId storeId = this.getStoreIdFromKernelStoreId(this.graphDb);
        GetIndexFilesRequest request = new GetIndexFilesRequest(storeId, indexId, lastCheckPointedTransactionId);
        return (StoreCopyFinishedResponse)this.catchUpClient.makeBlockingRequest(this.from, (CatchUpRequest)request, (CatchUpResponseCallback)StoreCopyResponseAdaptors.filesCopyAdaptor((StoreFileStreamProvider)this.streamToDiskProvider, (Log)this.log));
    }

    @Override
    public void close() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new PageCache[]{this.clientPageCache});
    }

    private static CheckPointer getCheckPointer(GraphDatabaseAPI graphDb) {
        return (CheckPointer)graphDb.getDependencyResolver().resolveDependency(CheckPointer.class);
    }
}

