/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.rule.TestDirectory;

public abstract class ConcurrentStressIT<T extends RaftLog & Lifecycle> {
    private static final int MAX_CONTENT_SIZE = 2048;
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory();
    private static final CharSequence CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    protected abstract T createRaftLog(FileSystemAbstraction var1, File var2);

    @Test
    public void readAndWrite() throws Throwable {
        this.readAndWrite(5, 2, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndWrite(int nReaders, int time, TimeUnit unit) throws Throwable {
        try (DefaultFileSystemAbstraction fsa = new DefaultFileSystemAbstraction();){
            LifeSupport lifeSupport = new LifeSupport();
            T raftLog = this.createRaftLog((FileSystemAbstraction)fsa, this.dir.directory());
            lifeSupport.add((Lifecycle)raftLog);
            lifeSupport.start();
            try {
                ExecutorService es = Executors.newCachedThreadPool();
                ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
                futures.add(es.submit(new TimedTask(() -> this.write((RaftLog)raftLog), time, unit)));
                for (int i = 0; i < nReaders; ++i) {
                    futures.add(es.submit(new TimedTask(() -> this.read((RaftLog)raftLog), time, unit)));
                }
                for (Future future : futures) {
                    long l = (Long)future.get();
                }
                es.shutdown();
            }
            finally {
                lifeSupport.shutdown();
            }
        }
    }

    private void read(RaftLog raftLog) {
        try (RaftLogCursor cursor = raftLog.getEntryCursor(0L);){
            while (cursor.next()) {
                RaftLogEntry entry = (RaftLogEntry)cursor.get();
                ReplicatedString content = (ReplicatedString)entry.content();
                Assert.assertEquals((Object)this.stringForIndex(cursor.index()), (Object)content.value());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(RaftLog raftLog) {
        long index = raftLog.appendIndex();
        long term = (index + 1L) * 3L;
        try {
            String data = this.stringForIndex(index + 1L);
            raftLog.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)new ReplicatedString(data))});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String stringForIndex(long index) {
        int len = (int)index % 2048 + 1;
        StringBuilder str = new StringBuilder(len);
        while (len-- > 0) {
            str.append(CHARS.charAt(len % CHARS.length()));
        }
        return str.toString();
    }

    private class TimedTask
    implements Callable<Long> {
        private Runnable task;
        private final long runTimeMillis;

        TimedTask(Runnable task, int time, TimeUnit unit) {
            this.task = task;
            this.runTimeMillis = unit.toMillis(time);
        }

        @Override
        public Long call() {
            long endTime = System.currentTimeMillis() + this.runTimeMillis;
            long count = 0L;
            while (endTime > System.currentTimeMillis()) {
                this.task.run();
                ++count;
            }
            return count;
        }
    }
}

