/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCacheMonitor;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;

public class ConsecutiveInFlightCacheTest {
    @Test
    public void shouldTrackUsedMemory() {
        int capacity = 4;
        ConsecutiveInFlightCache cache = new ConsecutiveInFlightCache(capacity, 1000L, InFlightCacheMonitor.VOID, true);
        for (int i = 0; i < capacity; ++i) {
            cache.put((long)i, this.content(100));
            Assert.assertEquals((long)((i + 1) * 100), (long)cache.totalBytes());
        }
        cache.put((long)capacity, this.content(100));
        Assert.assertEquals((long)capacity, (long)cache.elementCount());
        Assert.assertEquals((long)(capacity * 100), (long)cache.totalBytes());
        cache.put((long)(capacity + 1), this.content(500));
        Assert.assertEquals((long)capacity, (long)cache.elementCount());
        Assert.assertEquals((long)800L, (long)cache.totalBytes());
        cache.put((long)(capacity + 2), this.content(500));
        Assert.assertEquals((long)2L, (long)cache.elementCount());
        Assert.assertEquals((long)1000L, (long)cache.totalBytes());
    }

    @Test
    public void shouldReturnLatestItems() {
        int i;
        int capacity = 4;
        ConsecutiveInFlightCache cache = new ConsecutiveInFlightCache(capacity, 1000L, InFlightCacheMonitor.VOID, true);
        for (i = 0; i < 3 * capacity; ++i) {
            cache.put((long)i, this.content(i));
        }
        for (i = 0; i < 3 * capacity; ++i) {
            if (i < 2 * capacity) {
                Assert.assertEquals(null, (Object)cache.get((long)i));
                continue;
            }
            Assert.assertEquals((long)i, (long)cache.get((long)i).content().size());
        }
    }

    @Test
    public void shouldRemovePrunedItems() {
        int capacity = 20;
        ConsecutiveInFlightCache cache = new ConsecutiveInFlightCache(capacity, 1000L, InFlightCacheMonitor.VOID, true);
        for (int i = 0; i < capacity; ++i) {
            cache.put((long)i, this.content(i));
        }
        int upToIndex = capacity / 2 - 1;
        cache.prune((long)upToIndex);
        Assert.assertEquals((long)(capacity / 2), (long)cache.elementCount());
        for (int i = 0; i < capacity; ++i) {
            if (i <= upToIndex) {
                Assert.assertEquals(null, (Object)cache.get((long)i));
                continue;
            }
            Assert.assertEquals((long)i, (long)cache.get((long)i).content().size());
        }
    }

    @Test
    public void shouldRemoveTruncatedItems() {
        int capacity = 20;
        ConsecutiveInFlightCache cache = new ConsecutiveInFlightCache(capacity, 1000L, InFlightCacheMonitor.VOID, true);
        for (int i = 0; i < capacity; ++i) {
            cache.put((long)i, this.content(i));
        }
        int fromIndex = capacity / 2;
        cache.truncate((long)fromIndex);
        Assert.assertEquals((long)fromIndex, (long)cache.elementCount());
        Assert.assertEquals((long)(fromIndex * (fromIndex - 1) / 2), (long)cache.totalBytes());
        for (int i = fromIndex; i < capacity; ++i) {
            Assert.assertEquals(null, (Object)cache.get((long)i));
        }
    }

    private RaftLogEntry content(int size) {
        return new RaftLogEntry(0L, (ReplicatedContent)new DummyRequest(new byte[size]));
    }
}

