/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.segmented.OpenEndRangeMap;

public class OpenEndRangeMapTest {
    private OpenEndRangeMap<Integer, String> ranges = new OpenEndRangeMap();

    @Test
    public void shouldFindNothingInEmptyMap() {
        this.assertRange(-100, 100, new OpenEndRangeMap.ValueRange(null, null));
    }

    @Test
    public void shouldFindSingleRange() {
        this.ranges.replaceFrom((Comparable)Integer.valueOf(0), (Object)"A");
        this.assertRange(-100, -1, new OpenEndRangeMap.ValueRange((Object)0, null));
        this.assertRange(0, 100, new OpenEndRangeMap.ValueRange(null, (Object)"A"));
    }

    @Test
    public void shouldHandleMultipleRanges() {
        this.ranges.replaceFrom((Comparable)Integer.valueOf(0), (Object)"A");
        this.ranges.replaceFrom((Comparable)Integer.valueOf(5), (Object)"B");
        this.ranges.replaceFrom((Comparable)Integer.valueOf(10), (Object)"C");
        this.assertRange(-100, -1, new OpenEndRangeMap.ValueRange((Object)0, null));
        this.assertRange(0, 4, new OpenEndRangeMap.ValueRange((Object)5, (Object)"A"));
        this.assertRange(5, 9, new OpenEndRangeMap.ValueRange((Object)10, (Object)"B"));
        this.assertRange(10, 100, new OpenEndRangeMap.ValueRange(null, (Object)"C"));
    }

    @Test
    public void shouldTruncateAtPreviousEntry() {
        this.ranges.replaceFrom((Comparable)Integer.valueOf(0), (Object)"A");
        this.ranges.replaceFrom((Comparable)Integer.valueOf(10), (Object)"B");
        Collection removed = this.ranges.replaceFrom((Comparable)Integer.valueOf(10), (Object)"C");
        this.assertRange(-100, -1, new OpenEndRangeMap.ValueRange((Object)0, null));
        this.assertRange(0, 9, new OpenEndRangeMap.ValueRange((Object)10, (Object)"A"));
        this.assertRange(10, 100, new OpenEndRangeMap.ValueRange(null, (Object)"C"));
        MatcherAssert.assertThat((Object)removed, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"B"}));
    }

    @Test
    public void shouldTruncateBeforePreviousEntry() {
        this.ranges.replaceFrom((Comparable)Integer.valueOf(0), (Object)"A");
        this.ranges.replaceFrom((Comparable)Integer.valueOf(10), (Object)"B");
        Collection removed = this.ranges.replaceFrom((Comparable)Integer.valueOf(7), (Object)"C");
        this.assertRange(-100, -1, new OpenEndRangeMap.ValueRange((Object)0, null));
        this.assertRange(0, 6, new OpenEndRangeMap.ValueRange((Object)7, (Object)"A"));
        this.assertRange(7, 100, new OpenEndRangeMap.ValueRange(null, (Object)"C"));
        MatcherAssert.assertThat((Object)removed, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"B"}));
    }

    @Test
    public void shouldTruncateSeveralEntries() {
        this.ranges.replaceFrom((Comparable)Integer.valueOf(0), (Object)"A");
        this.ranges.replaceFrom((Comparable)Integer.valueOf(10), (Object)"B");
        this.ranges.replaceFrom((Comparable)Integer.valueOf(20), (Object)"C");
        this.ranges.replaceFrom((Comparable)Integer.valueOf(30), (Object)"D");
        Collection removed = this.ranges.replaceFrom((Comparable)Integer.valueOf(15), (Object)"E");
        this.assertRange(-100, -1, new OpenEndRangeMap.ValueRange((Object)0, null));
        this.assertRange(0, 9, new OpenEndRangeMap.ValueRange((Object)10, (Object)"A"));
        this.assertRange(10, 14, new OpenEndRangeMap.ValueRange((Object)15, (Object)"B"));
        this.assertRange(15, 100, new OpenEndRangeMap.ValueRange(null, (Object)"E"));
        MatcherAssert.assertThat((Object)removed, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"C", "D"}));
    }

    @Test
    public void shouldOnlyPruneWholeEntries() {
        this.ranges.replaceFrom((Comparable)Integer.valueOf(0), (Object)"A");
        this.ranges.replaceFrom((Comparable)Integer.valueOf(5), (Object)"B");
        Collection removed = this.ranges.remove((Comparable)Integer.valueOf(4));
        Assert.assertTrue((boolean)removed.isEmpty());
        removed = this.ranges.remove((Comparable)Integer.valueOf(5));
        Assert.assertFalse((boolean)removed.isEmpty());
        MatcherAssert.assertThat((Object)removed, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"A"}));
    }

    private <T> void assertRange(int from, int to, OpenEndRangeMap.ValueRange<Integer, T> expected) {
        for (int i = from; i <= to; ++i) {
            OpenEndRangeMap.ValueRange valueRange = this.ranges.lookup((Comparable)Integer.valueOf(i));
            Assert.assertEquals(expected, (Object)valueRange);
        }
    }
}

