/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.DamagedLogStorageException;
import org.neo4j.causalclustering.core.consensus.log.segmented.DisposedException;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.RecoveryProtocol;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.core.consensus.log.segmented.State;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.time.Clocks;

public class SegmentedRaftLogPartialEntryRecoveryTest {
    @Rule
    public final DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory((FileSystemAbstraction)this.fsRule.get());
    private File logDirectory;
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.dir);

    private SegmentedRaftLog createRaftLog(long rotateAtSize) {
        File directory = new File("raft-log");
        this.logDirectory = this.dir.directory(directory.getName());
        NullLogProvider logProvider = NullLogProvider.getInstance();
        CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory("100 entries", (LogProvider)logProvider).newInstance();
        return new SegmentedRaftLog(this.fsRule.get(), this.logDirectory, rotateAtSize, (ChannelMarshal)new CoreReplicatedContentMarshal(), (LogProvider)logProvider, 8, (Clock)Clocks.fakeClock(), (JobScheduler)new OnDemandJobScheduler(), pruningStrategy);
    }

    private RecoveryProtocol createRecoveryProtocol() {
        FileNames fileNames = new FileNames(this.logDirectory);
        return new RecoveryProtocol(this.fsRule.get(), fileNames, new ReaderPool(8, (LogProvider)NullLogProvider.getInstance(), fileNames, this.fsRule.get(), (Clock)Clocks.fakeClock()), (ChannelMarshal)new CoreReplicatedContentMarshal(), (LogProvider)NullLogProvider.getInstance());
    }

    @Test
    public void incompleteEntriesAtTheEndShouldNotCauseFailures() throws Throwable {
        SegmentedRaftLog raftLog = this.createRaftLog(100000L);
        raftLog.start();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)new NewLeaderBarrier())});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)new ReplicatedIdAllocationRequest(new MemberId(UUID.randomUUID()), IdType.RELATIONSHIP, 1L, 1024))});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)new ReplicatedIdAllocationRequest(new MemberId(UUID.randomUUID()), IdType.RELATIONSHIP, 1025L, 1024))});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)new ReplicatedLockTokenRequest(new MemberId(UUID.randomUUID()), 1))});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)new NewLeaderBarrier())});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(5L, (ReplicatedContent)new ReplicatedTokenRequest(TokenType.LABEL, "labelToken", new byte[]{1, 2, 3}))});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(5L, (ReplicatedContent)new ReplicatedTransaction(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}))});
        raftLog.stop();
        RecoveryProtocol recovery = this.createRecoveryProtocol();
        State recoveryState = recovery.run();
        String logFilename = recoveryState.segments.last().getFilename();
        recoveryState.segments.close();
        File logFile = new File(this.logDirectory, logFilename);
        this.truncateAndRecover(logFile, 32L);
    }

    @Test
    public void incompleteHeaderOfLastOfMoreThanOneLogFilesShouldNotCauseFailure() throws Throwable {
        SegmentedRaftLog raftLog = this.createRaftLog(1L);
        raftLog.start();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)new NewLeaderBarrier())});
        raftLog.stop();
        RecoveryProtocol recovery = this.createRecoveryProtocol();
        State recoveryState = recovery.run();
        String logFilename = recoveryState.segments.last().getFilename();
        recoveryState.segments.close();
        File logFile = new File(this.logDirectory, logFilename);
        this.truncateAndRecover(logFile, 0L);
    }

    @Test
    public void shouldNotAppendAtTheEndOfLogFileWithIncompleteEntries() throws Throwable {
        SegmentedRaftLog raftLog = this.createRaftLog(100000L);
        raftLog.start();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)new NewLeaderBarrier())});
        raftLog.stop();
        RecoveryProtocol recovery = this.createRecoveryProtocol();
        State recoveryState = recovery.run();
        String logFilename = recoveryState.segments.last().getFilename();
        recoveryState.segments.close();
        File logFile = new File(this.logDirectory, logFilename);
        StoreFileChannel lastFile = ((DefaultFileSystemAbstraction)this.fsRule.get()).open(logFile, OpenMode.READ_WRITE);
        long currentSize = lastFile.size();
        lastFile.close();
        lastFile = ((DefaultFileSystemAbstraction)this.fsRule.get()).open(logFile, OpenMode.READ_WRITE);
        lastFile.truncate(currentSize - 1L);
        lastFile.close();
        raftLog = this.createRaftLog(100000L);
        raftLog.start();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(4L, (ReplicatedContent)new NewLeaderBarrier())});
        try (RaftLogCursor entryCursor = raftLog.getEntryCursor(0L);){
            Assert.assertTrue((boolean)entryCursor.next());
            RaftLogEntry raftLogEntry = (RaftLogEntry)entryCursor.get();
            Assert.assertEquals(NewLeaderBarrier.class, raftLogEntry.content().getClass());
            Assert.assertFalse((boolean)entryCursor.next());
        }
        raftLog.stop();
    }

    private void truncateAndRecover(File logFile, long truncateDownToSize) throws IOException, DamagedLogStorageException, DisposedException {
        StoreFileChannel lastFile = ((DefaultFileSystemAbstraction)this.fsRule.get()).open(logFile, OpenMode.READ_WRITE);
        long currentSize = lastFile.size();
        lastFile.close();
        while (currentSize-- > truncateDownToSize) {
            lastFile = ((DefaultFileSystemAbstraction)this.fsRule.get()).open(logFile, OpenMode.READ_WRITE);
            lastFile.truncate(currentSize);
            lastFile.close();
            RecoveryProtocol recovery = this.createRecoveryProtocol();
            State state = recovery.run();
            state.segments.close();
        }
    }
}

