/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.NetworkFlushableByteBuf;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreReplicatedContentMarshalTest {
    private final ChannelMarshal<ReplicatedContent> marshal = new CoreReplicatedContentMarshal();

    @Test
    public void shouldMarshalTransactionReference() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(Collections.emptyList());
        representation.setHeader(new byte[]{0}, 1, 1, 1L, 1L, 1L, 1);
        ReplicatedTransaction replicatedTx = ReplicatedTransactionFactory.createImmutableReplicatedTransaction((TransactionRepresentation)representation);
        this.assertMarshalingEquality(buffer, (ReplicatedContent)replicatedTx);
    }

    @Test
    public void shouldMarshalTransactionReferenceWithMissingHeader() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(Collections.emptyList());
        ReplicatedTransaction replicatedTx = ReplicatedTransactionFactory.createImmutableReplicatedTransaction((TransactionRepresentation)representation);
        this.assertMarshalingEquality(buffer, (ReplicatedContent)replicatedTx);
    }

    @Test
    public void shouldMarshalMemberSet() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        MemberIdSet message = new MemberIdSet(Iterators.asSet((Object[])new MemberId[]{new MemberId(UUID.randomUUID()), new MemberId(UUID.randomUUID())}));
        this.assertMarshalingEquality(buffer, (ReplicatedContent)message);
    }

    @Test
    public void shouldMarshalIdRangeRequest() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        ReplicatedIdAllocationRequest message = new ReplicatedIdAllocationRequest(new MemberId(UUID.randomUUID()), IdType.PROPERTY, 100L, 200);
        this.assertMarshalingEquality(buffer, (ReplicatedContent)message);
    }

    @Test
    public void shouldMarshalTokenRequest() throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        ArrayList<Command.LabelTokenCommand> commands = new ArrayList<Command.LabelTokenCommand>();
        LabelTokenRecord before = new LabelTokenRecord(0);
        LabelTokenRecord after = new LabelTokenRecord(0);
        after.setInUse(true);
        after.setCreated();
        after.setNameId(3232);
        commands.add(new Command.LabelTokenCommand(before, after));
        ReplicatedTokenRequest message = new ReplicatedTokenRequest(TokenType.LABEL, "theLabel", ReplicatedTokenRequestSerializer.commandBytes(commands));
        this.assertMarshalingEquality(buffer, (ReplicatedContent)message);
    }

    private void assertMarshalingEquality(ByteBuf buffer, ReplicatedContent replicatedTx) throws IOException, EndOfStreamException {
        this.marshal.marshal((Object)replicatedTx, (WritableChannel)new NetworkFlushableByteBuf(buffer));
        MatcherAssert.assertThat((Object)this.marshal.unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(buffer)), (Matcher)CoreMatchers.equalTo((Object)replicatedTx));
    }
}

