/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.SessionTracker;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.log.monitoring.RaftLogCommitIndexMonitor;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ProgressTracker;
import org.neo4j.causalclustering.core.replication.ProgressTrackerImpl;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.tx.CoreReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CommandApplicationProcessTest {
    private final InMemoryRaftLog raftLog = (InMemoryRaftLog)Mockito.spy((Object)new InMemoryRaftLog());
    private final SessionTracker sessionTracker = new SessionTracker((StateStorage)new InMemoryStateStorage((Object)new GlobalSessionTrackerState()));
    private final DatabaseHealth dbHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), NullLogProvider.getInstance().getLog(this.getClass()));
    private final GlobalSession globalSession = new GlobalSession(UUID.randomUUID(), null);
    private final int flushEvery = 10;
    private final int batchSize = 16;
    private InFlightCache inFlightCache = (InFlightCache)Mockito.spy((Object)new ConsecutiveInFlightCache());
    private final Monitors monitors = new Monitors();
    private CoreState coreState = (CoreState)Mockito.mock(CoreState.class);
    private final CommandApplicationProcess applicationProcess = new CommandApplicationProcess((RaftLog)this.raftLog, 16, 10, () -> this.dbHealth, (LogProvider)NullLogProvider.getInstance(), (ProgressTracker)new ProgressTrackerImpl(this.globalSession), this.sessionTracker, this.coreState, this.inFlightCache, this.monitors);
    private ReplicatedTransaction nullTx = new ReplicatedTransaction(new byte[0]);
    private final CommandDispatcher commandDispatcher = (CommandDispatcher)Mockito.mock(CommandDispatcher.class);
    private int sequenceNumber;

    public CommandApplicationProcessTest() {
        Mockito.when((Object)this.coreState.commandDispatcher()).thenReturn((Object)this.commandDispatcher);
        Mockito.when((Object)this.coreState.getLastAppliedIndex()).thenReturn((Object)-1L);
        Mockito.when((Object)this.coreState.getLastFlushed()).thenReturn((Object)-1L);
    }

    private ReplicatedTransaction tx(byte dataValue) {
        byte[] dataArray = new byte[30];
        Arrays.fill(dataArray, dataValue);
        return new ReplicatedTransaction(dataArray);
    }

    private synchronized ReplicatedContent operation(CoreReplicatedContent tx) {
        return new DistributedOperation((ReplicatedContent)tx, this.globalSession, new LocalOperationId(0L, (long)this.sequenceNumber++));
    }

    @Test
    public void shouldApplyCommittedCommand() throws Throwable {
        RaftLogCommitIndexMonitor listener = (RaftLogCommitIndexMonitor)Mockito.mock(RaftLogCommitIndexMonitor.class);
        this.monitors.addMonitorListener((Object)listener, new String[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreState, this.commandDispatcher});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(2L);
        this.applicationProcess.start();
        ((CoreState)inOrder.verify((Object)this.coreState)).commandDispatcher();
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.nullTx), ArgumentMatchers.eq((long)0L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.nullTx), ArgumentMatchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.nullTx), ArgumentMatchers.eq((long)2L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).close();
        ((RaftLogCommitIndexMonitor)Mockito.verify((Object)listener)).commitIndex(2L);
    }

    @Test
    public void shouldNotApplyUncommittedCommands() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(-1L);
        this.applicationProcess.start();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.commandDispatcher});
    }

    @Test
    public void entriesThatAreNotStateMachineCommandsShouldStillIncreaseCommandIndex() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(1L);
        this.applicationProcess.start();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreState, this.commandDispatcher});
        ((CoreState)inOrder.verify((Object)this.coreState)).commandDispatcher();
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.nullTx), ArgumentMatchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).close();
    }

    @Test
    public void duplicatesShouldBeIgnoredButStillIncreaseCommandIndex() throws Exception {
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.nullTx, this.globalSession, new LocalOperationId(0L, 0L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.nullTx, this.globalSession, new LocalOperationId(0L, 0L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.nullTx, this.globalSession, new LocalOperationId(0L, 1L)))});
        this.applicationProcess.notifyCommitted(3L);
        this.applicationProcess.start();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreState, this.commandDispatcher});
        ((CoreState)inOrder.verify((Object)this.coreState)).commandDispatcher();
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.nullTx), ArgumentMatchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.nullTx), ArgumentMatchers.eq((long)3L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.commandDispatcher});
    }

    @Test
    public void outOfOrderDuplicatesShouldBeIgnoredButStillIncreaseCommandIndex() throws Exception {
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)100), this.globalSession, new LocalOperationId(0L, 0L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)101), this.globalSession, new LocalOperationId(0L, 1L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)102), this.globalSession, new LocalOperationId(0L, 2L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)101), this.globalSession, new LocalOperationId(0L, 1L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)100), this.globalSession, new LocalOperationId(0L, 0L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)103), this.globalSession, new LocalOperationId(0L, 3L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)104), this.globalSession, new LocalOperationId(0L, 4L)))});
        this.applicationProcess.notifyCommitted(6L);
        this.applicationProcess.start();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreState, this.commandDispatcher});
        ((CoreState)inOrder.verify((Object)this.coreState)).commandDispatcher();
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.tx((byte)100)), ArgumentMatchers.eq((long)0L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.tx((byte)101)), ArgumentMatchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.tx((byte)102)), ArgumentMatchers.eq((long)2L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.tx((byte)103)), ArgumentMatchers.eq((long)5L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.eq((Object)this.tx((byte)104)), ArgumentMatchers.eq((long)6L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.commandDispatcher});
    }

    @Test
    public void shouldPeriodicallyFlushState() throws Throwable {
        int interactions = 50;
        for (int i = 0; i < interactions; ++i) {
            this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        }
        this.applicationProcess.notifyCommitted(this.raftLog.appendIndex());
        this.applicationProcess.start();
        ((CoreState)Mockito.verify((Object)this.coreState)).flush(15L);
        ((CoreState)Mockito.verify((Object)this.coreState)).flush(31L);
        ((CoreState)Mockito.verify((Object)this.coreState)).flush(47L);
    }

    @Test
    public void shouldPanicIfUnableToApply() throws Throwable {
        ((CommandDispatcher)Mockito.doThrow(RuntimeException.class).when((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)ArgumentMatchers.any(ReplicatedTransaction.class), ArgumentMatchers.anyLong(), this.anyCallback());
        this.applicationProcess.start();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(0L);
        org.neo4j.test.assertion.Assert.assertEventually((String)"failed apply", () -> ((DatabaseHealth)this.dbHealth).isHealthy(), (Matcher)Matchers.is((Object)false), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void shouldApplyToLogFromCache() throws Throwable {
        this.inFlightCache.put(0L, new RaftLogEntry(1L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.applicationProcess.notifyCommitted(0L);
        this.applicationProcess.start();
        ((InFlightCache)Mockito.verify((Object)this.inFlightCache, (VerificationMode)Mockito.times((int)1))).get(0L);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.raftLog});
    }

    @Test
    public void cacheEntryShouldBePurgedAfterBeingApplied() throws Throwable {
        this.inFlightCache.put(0L, new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.inFlightCache.put(1L, new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.inFlightCache.put(2L, new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.applicationProcess.notifyCommitted(0L);
        this.applicationProcess.start();
        Assert.assertNull((Object)this.inFlightCache.get(0L));
        Assert.assertNotNull((Object)this.inFlightCache.get(1L));
        Assert.assertNotNull((Object)this.inFlightCache.get(2L));
    }

    @Test
    public void shouldFailWhenCacheAndLogMiss() throws Throwable {
        this.inFlightCache.put(0L, new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(2L);
        try {
            this.applicationProcess.start();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldIncreaseLastAppliedForStateMachineCommands() throws Exception {
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(2L);
        this.applicationProcess.start();
        Assert.assertEquals((long)2L, (long)this.applicationProcess.lastApplied());
    }

    @Test
    public void shouldIncreaseLastAppliedForOtherCommands() throws Exception {
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.applicationProcess.notifyCommitted(2L);
        this.applicationProcess.start();
        Assert.assertEquals((long)2L, (long)this.applicationProcess.lastApplied());
    }

    private Consumer<Result> anyCallback() {
        Consumer anyCallback = (Consumer)ArgumentMatchers.any(Consumer.class);
        return anyCallback;
    }
}

