/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.backup.RestoreClusterUtils;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.state.CoreBootstrapper;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.tx.LastCommittedIndexFinder;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateType;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class CoreBootstrapperIT {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.pageCacheRule).around((TestRule)this.pageCacheRule).around((TestRule)this.testDirectory);

    @Test
    public void shouldSetAllCoreState() throws Exception {
        int nodeCount = 100;
        FileSystemAbstraction fileSystem = this.fileSystemRule.get();
        File classicNeo4jStore = RestoreClusterUtils.createClassicNeo4jStore(this.testDirectory.directory(), fileSystem, nodeCount, "standard");
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystem);
        CoreBootstrapper bootstrapper = new CoreBootstrapper(classicNeo4jStore, pageCache, fileSystem, Config.defaults(), (LogProvider)NullLogProvider.getInstance());
        this.bootstrapAndVerify(nodeCount, fileSystem, classicNeo4jStore, pageCache, Config.defaults(), bootstrapper);
    }

    @Test
    public void setAllCoreStateOnDatabaseWithCustomLogFilesLocation() throws Exception {
        int nodeCount = 100;
        FileSystemAbstraction fileSystem = this.fileSystemRule.get();
        File baseDirectory = this.testDirectory.directory();
        String customTransactionLogsLocation = "transaction-logs";
        File classicNeo4jStore = RestoreClusterUtils.createClassicNeo4jStore(baseDirectory, fileSystem, nodeCount, "standard", customTransactionLogsLocation);
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystem);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.logical_logs_location, (String)customTransactionLogsLocation);
        CoreBootstrapper bootstrapper = new CoreBootstrapper(classicNeo4jStore, pageCache, fileSystem, config, (LogProvider)NullLogProvider.getInstance());
        this.bootstrapAndVerify(nodeCount, fileSystem, classicNeo4jStore, pageCache, config, bootstrapper);
    }

    private void bootstrapAndVerify(long nodeCount, FileSystemAbstraction fileSystem, File classicNeo4jStore, PageCache pageCache, Config config, CoreBootstrapper bootstrapper) throws IOException {
        Set membership = Iterators.asSet((Object[])new MemberId[]{this.randomMember(), this.randomMember(), this.randomMember()});
        CoreSnapshot snapshot = bootstrapper.bootstrap(membership);
        int recordIdBatchSize = Integer.parseInt(GraphDatabaseSettings.record_id_batch_size.getDefaultValue());
        Assert.assertThat((Object)((IdAllocationState)snapshot.get(CoreStateType.ID_ALLOCATION)).firstUnallocated(IdType.NODE), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(nodeCount)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(nodeCount + (long)recordIdBatchSize))));
        Assert.assertEquals((long)0L, (long)snapshot.prevIndex());
        Assert.assertEquals((long)0L, (long)snapshot.prevTerm());
        Assert.assertEquals((Object)new ReplicatedLockTokenState(), (Object)snapshot.get(CoreStateType.LOCK_TOKEN));
        Assert.assertEquals((Object)membership, (Object)((RaftCoreState)snapshot.get(CoreStateType.RAFT_CORE_STATE)).committed().members());
        Assert.assertEquals((Object)new GlobalSessionTrackerState(), (Object)snapshot.get(CoreStateType.SESSION_TRACKER));
        ReadOnlyTransactionStore transactionStore = new ReadOnlyTransactionStore(pageCache, fileSystem, classicNeo4jStore, config, new Monitors());
        LastCommittedIndexFinder lastCommittedIndexFinder = new LastCommittedIndexFinder((TransactionIdStore)new ReadOnlyTransactionIdStore(pageCache, classicNeo4jStore), (LogicalTransactionStore)transactionStore, (LogProvider)NullLogProvider.getInstance());
        long lastCommittedIndex = lastCommittedIndexFinder.getLastCommittedIndex();
        Assert.assertEquals((long)-1L, (long)lastCommittedIndex);
    }

    private MemberId randomMember() {
        return new MemberId(UUID.randomUUID());
    }
}

