/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocation;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdGeneratorFactory;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.id.EnterpriseIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RebuildReplicatedIdGeneratorsTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private ReplicatedIdRangeAcquirer idRangeAcquirer = (ReplicatedIdRangeAcquirer)Mockito.mock(ReplicatedIdRangeAcquirer.class);

    @Test
    public void rebuildReplicatedIdGeneratorsOnRecovery() throws Exception {
        DefaultFileSystemAbstraction fileSystem = (DefaultFileSystemAbstraction)this.fileSystemRule.get();
        File stickyGenerator = new File(this.testDirectory.graphDbDir(), "stickyGenerator");
        File nodeStoreIdGenerator = new File(this.testDirectory.graphDbDir(), "neostore.nodestore.db.id");
        StoreFactory storeFactory = new StoreFactory(this.testDirectory.graphDbDir(), Config.defaults(), (IdGeneratorFactory)this.getIdGenerationFactory((FileSystemAbstraction)fileSystem), this.pageCacheRule.getPageCache((FileSystemAbstraction)fileSystem), (FileSystemAbstraction)fileSystem, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        try (NeoStores neoStores = storeFactory.openAllNeoStores(true);){
            NodeStore nodeStore = neoStores.getNodeStore();
            for (int i = 0; i < 50; ++i) {
                NodeRecord nodeRecord = (NodeRecord)nodeStore.newRecord();
                nodeRecord.setInUse(true);
                nodeRecord.setId(nodeStore.nextId());
                if (i == 47) {
                    FileUtils.copyFile((File)nodeStoreIdGenerator, (File)stickyGenerator);
                }
                nodeStore.updateRecord(nodeRecord);
            }
            neoStores.close();
        }
        FileUtils.copyFile((File)stickyGenerator, (File)nodeStoreIdGenerator);
        var6_6 = null;
        try (NeoStores reopenedStores = storeFactory.openAllNeoStores();){
            reopenedStores.makeStoreOk();
            Assert.assertEquals((long)51L, (long)reopenedStores.getNodeStore().nextId());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    private ReplicatedIdGeneratorFactory getIdGenerationFactory(FileSystemAbstraction fileSystemAbstraction) {
        Mockito.when((Object)this.idRangeAcquirer.acquireIds(IdType.NODE)).thenReturn((Object)new IdAllocation(new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 0L, 10000), 0L, 0L));
        return new ReplicatedIdGeneratorFactory(fileSystemAbstraction, this.idRangeAcquirer, (LogProvider)NullLogProvider.getInstance(), (IdTypeConfigurationProvider)new EnterpriseIdTypeConfigurationProvider(Config.defaults()));
    }
}

