/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.state.machines.tx.LogIndexTxHeaderEncoding;

public class LogIndexTxHeaderEncodingTest {
    @Test
    public void shouldEncodeIndexAsBytes() {
        long index = 123456789012567L;
        byte[] bytes = LogIndexTxHeaderEncoding.encodeLogIndexAsTxHeader((long)index);
        Assert.assertEquals((long)index, (long)LogIndexTxHeaderEncoding.decodeLogIndexFromTxHeader((byte[])bytes));
    }

    @Test
    public void shouldThrowExceptionForAnEmptyByteArray() {
        try {
            LogIndexTxHeaderEncoding.decodeLogIndexFromTxHeader((byte[])new byte[0]);
            Assert.fail((String)"Should have thrown an exception because there's no way to decode this ");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Unable to decode RAFT log index from transaction header", (Object)e.getMessage());
        }
    }
}

