/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.state.machines.tx.ReplayableCommitProcess;
import org.neo4j.causalclustering.core.state.machines.tx.TransactionCounter;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class ReplayableCommitProcessTest {
    @Test
    public void shouldCommitTransactions() throws Exception {
        TransactionToApply newTx1 = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        TransactionToApply newTx2 = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        TransactionToApply newTx3 = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        StubLocalDatabase localDatabase = new StubLocalDatabase(1L);
        ReplayableCommitProcess txListener = new ReplayableCommitProcess((TransactionCommitProcess)localDatabase, (TransactionCounter)localDatabase);
        txListener.commit(newTx1, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        txListener.commit(newTx2, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        txListener.commit(newTx3, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        ((TransactionCommitProcess)Mockito.verify((Object)localDatabase.commitProcess, (VerificationMode)Mockito.times((int)3))).commit((TransactionToApply)ArgumentMatchers.any(TransactionToApply.class), (CommitEvent)ArgumentMatchers.any(CommitEvent.class), (TransactionApplicationMode)ArgumentMatchers.any(TransactionApplicationMode.class));
    }

    @Test
    public void shouldNotCommitTransactionsThatAreAlreadyCommittedLocally() throws Exception {
        TransactionToApply alreadyCommittedTx1 = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        TransactionToApply alreadyCommittedTx2 = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        TransactionToApply newTx = (TransactionToApply)Mockito.mock(TransactionToApply.class);
        StubLocalDatabase localDatabase = new StubLocalDatabase(3L);
        ReplayableCommitProcess txListener = new ReplayableCommitProcess((TransactionCommitProcess)localDatabase, (TransactionCounter)localDatabase);
        txListener.commit(alreadyCommittedTx1, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        txListener.commit(alreadyCommittedTx2, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        txListener.commit(newTx, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        ((TransactionCommitProcess)Mockito.verify((Object)localDatabase.commitProcess, (VerificationMode)Mockito.times((int)1))).commit((TransactionToApply)ArgumentMatchers.eq((Object)newTx), (CommitEvent)ArgumentMatchers.any(CommitEvent.class), (TransactionApplicationMode)ArgumentMatchers.any(TransactionApplicationMode.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{localDatabase.commitProcess});
    }

    private static class StubLocalDatabase
    extends LifecycleAdapter
    implements TransactionCounter,
    TransactionCommitProcess {
        long lastCommittedTransactionId;
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);

        StubLocalDatabase(long lastCommittedTransactionId) {
            this.lastCommittedTransactionId = lastCommittedTransactionId;
        }

        public long lastCommittedTransactionId() {
            return this.lastCommittedTransactionId;
        }

        public long commit(TransactionToApply tx, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
            ++this.lastCommittedTransactionId;
            return this.commitProcess.commit(tx, commitEvent, mode);
        }
    }
}

