/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class ClientConnectorAddressesTest {
    @Test
    public void shouldSerializeToString() {
        ClientConnectorAddresses connectorAddresses = new ClientConnectorAddresses(Arrays.asList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, new AdvertisedSocketAddress("host", 1)), new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.http, new AdvertisedSocketAddress("host", 2)), new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.https, new AdvertisedSocketAddress("host", 3)), new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, new AdvertisedSocketAddress("::1", 4)), new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.http, new AdvertisedSocketAddress("::", 5)), new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.https, new AdvertisedSocketAddress("fe80:1:2::3", 6))));
        String expectedString = "bolt://host:1,http://host:2,https://host:3,bolt://[::1]:4,http://[::]:5,https://[fe80:1:2::3]:6";
        String connectorAddressesString = connectorAddresses.toString();
        Assert.assertEquals((Object)expectedString, (Object)connectorAddressesString);
        ClientConnectorAddresses out = ClientConnectorAddresses.fromString((String)connectorAddressesString);
        Assert.assertEquals((Object)connectorAddresses, (Object)out);
    }

    @Test
    public void shouldSerializeWithNoHttpsAddress() {
        ClientConnectorAddresses connectorAddresses = new ClientConnectorAddresses(Arrays.asList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, new AdvertisedSocketAddress("host", 1)), new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.http, new AdvertisedSocketAddress("host", 2))));
        ClientConnectorAddresses out = ClientConnectorAddresses.fromString((String)connectorAddresses.toString());
        Assert.assertEquals((Object)connectorAddresses, (Object)out);
    }
}

