/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MultiMap;
import com.hazelcast.nio.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.helpers.CausalClusteringTestHelpers;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class HazelcastClusterTopologyTest {
    private static final Set<String> GROUPS = Iterators.asSet((Object[])new String[]{"group1", "group2", "group3"});
    private static final Set<String> DB_NAMES = Stream.of("foo", "bar", "baz").collect(Collectors.toSet());
    private static final String DEFAULT_DB_NAME = "default";
    private static final IntFunction<HashMap<String, String>> DEFAULT_SETTINGS_GENERATOR = i -> {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(CausalClusteringSettings.transaction_advertised_address.name(), "tx:" + (i + 1));
        settings.put(CausalClusteringSettings.raft_advertised_address.name(), "raft:" + (i + 1));
        settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(new BoltConnector((String)"bolt").advertised_address.name(), "bolt:" + (i + 1));
        settings.put(new BoltConnector((String)"http").type.name(), "HTTP");
        settings.put(new BoltConnector((String)"http").enabled.name(), "true");
        settings.put(new BoltConnector((String)"http").advertised_address.name(), "http:" + (i + 1));
        return settings;
    };
    private final HazelcastInstance hzInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);

    @Before
    public void setup() {
        MultiMap serverGroupsMMap = (MultiMap)Mockito.mock(MultiMap.class);
        Mockito.when((Object)serverGroupsMMap.get(ArgumentMatchers.any())).thenReturn(GROUPS);
        Mockito.when((Object)this.hzInstance.getMultiMap(ArgumentMatchers.anyString())).thenReturn((Object)serverGroupsMMap);
    }

    private static List<Config> generateConfigs(int numConfigs) {
        return HazelcastClusterTopologyTest.generateConfigs(numConfigs, DEFAULT_SETTINGS_GENERATOR);
    }

    private static List<Config> generateConfigs(int numConfigs, IntFunction<HashMap<String, String>> generator) {
        return IntStream.range(0, numConfigs).mapToObj(generator).map(Config::defaults).collect(Collectors.toList());
    }

    @Test
    public void shouldCollectMembersAsAMap() throws Exception {
        int numMembers = 5;
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        List<Config> configs = HazelcastClusterTopologyTest.generateConfigs(numMembers);
        for (int i = 0; i < configs.size(); ++i) {
            MemberId mId = new MemberId(UUID.randomUUID());
            coreMembers.add(mId);
            Config c = configs.get(i);
            Map attributes = HazelcastClusterTopology.buildMemberAttributesForCore((MemberId)mId, (Config)c).getAttributes();
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i), null, attributes, false));
        }
        Map coreMemberMap = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)NullLog.getInstance(), (HazelcastInstance)this.hzInstance);
        for (int i = 0; i < numMembers; ++i) {
            CoreServerInfo coreServerInfo = (CoreServerInfo)coreMemberMap.get(coreMembers.get(i));
            Assert.assertEquals((Object)new AdvertisedSocketAddress("tx", i + 1), (Object)coreServerInfo.getCatchupServer());
            Assert.assertEquals((Object)new AdvertisedSocketAddress("raft", i + 1), (Object)coreServerInfo.getRaftServer());
            Assert.assertEquals((Object)new AdvertisedSocketAddress("bolt", i + 1), (Object)coreServerInfo.connectors().boltAddress());
            Assert.assertEquals((Object)coreServerInfo.getDatabaseName(), (Object)DEFAULT_DB_NAME);
            Assert.assertEquals((Object)coreServerInfo.groups(), GROUPS);
        }
    }

    @Test
    public void shouldBuildMemberAttributedWithSpecifiedDBNames() throws Exception {
        int numMembers = 10;
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        Map<Integer, String> dbNames = CausalClusteringTestHelpers.distributeDatabaseNamesToHostNums(numMembers, DB_NAMES);
        IntFunction<HashMap<String, String>> generator = i -> {
            HashMap<String, String> settings = DEFAULT_SETTINGS_GENERATOR.apply(i);
            settings.put(CausalClusteringSettings.database.name(), (String)dbNames.get(i));
            return settings;
        };
        List<Config> configs = HazelcastClusterTopologyTest.generateConfigs(numMembers, generator);
        for (int i2 = 0; i2 < configs.size(); ++i2) {
            MemberId mId = new MemberId(UUID.randomUUID());
            coreMembers.add(mId);
            Config c = configs.get(i2);
            Map attributes = HazelcastClusterTopology.buildMemberAttributesForCore((MemberId)mId, (Config)c).getAttributes();
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i2), null, attributes, false));
        }
        Map coreMemberMap = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)NullLog.getInstance(), (HazelcastInstance)this.hzInstance);
        for (int i3 = 0; i3 < numMembers; ++i3) {
            CoreServerInfo coreServerInfo = (CoreServerInfo)coreMemberMap.get(coreMembers.get(i3));
            String expectedDBName = dbNames.get(i3);
            Assert.assertEquals((Object)expectedDBName, (Object)coreServerInfo.getDatabaseName());
        }
    }

    @Test
    public void shouldLogAndExcludeMembersWithMissingAttributes() throws Exception {
        int numMembers = 4;
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        IntFunction<HashMap<String, String>> generator = i -> {
            HashMap<String, String> settings = DEFAULT_SETTINGS_GENERATOR.apply(i);
            settings.remove(CausalClusteringSettings.transaction_advertised_address.name());
            settings.remove(CausalClusteringSettings.raft_advertised_address.name());
            return settings;
        };
        List<Config> configs = HazelcastClusterTopologyTest.generateConfigs(numMembers, generator);
        for (int i2 = 0; i2 < configs.size(); ++i2) {
            MemberId memberId = new MemberId(UUID.randomUUID());
            coreMembers.add(memberId);
            Config c = configs.get(i2);
            Map attributes = HazelcastClusterTopology.buildMemberAttributesForCore((MemberId)memberId, (Config)c).getAttributes();
            if (i2 == 2) {
                attributes.remove("raft_server");
            }
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i2), null, attributes, false));
        }
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        Map map = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)log, (HazelcastInstance)this.hzInstance);
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new MemberId[]{(MemberId)coreMembers.get(0), (MemberId)coreMembers.get(1), (MemberId)coreMembers.get(3)}));
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new MemberId[]{(MemberId)coreMembers.get(2)})));
        logProvider.assertContainsMessageContaining("Missing member attribute");
    }

    @Test
    public void shouldCorrectlyReturnCoreMemberRoles() {
        int numMembers = 3;
        List members = IntStream.range(0, numMembers).mapToObj(ignored -> new MemberId(UUID.randomUUID())).collect(Collectors.toList());
        IAtomicReference leaderRef = (IAtomicReference)Mockito.mock(IAtomicReference.class);
        MemberId chosenLeaderId = (MemberId)members.get(0);
        Mockito.when((Object)leaderRef.get()).thenReturn((Object)new LeaderInfo(chosenLeaderId, 0L));
        IMap uuidDBMap = (IMap)Mockito.mock(IMap.class);
        Mockito.when((Object)uuidDBMap.keySet()).thenReturn(Collections.singleton(DEFAULT_DB_NAME));
        Mockito.when((Object)this.hzInstance.getAtomicReference(ArgumentMatchers.startsWith((String)"leader_term_for_database_name_"))).thenReturn((Object)leaderRef);
        Mockito.when((Object)this.hzInstance.getMap((String)ArgumentMatchers.eq((Object)"cluster_uuid"))).thenReturn((Object)uuidDBMap);
        Map roleMap = HazelcastClusterTopology.getCoreRoles((HazelcastInstance)this.hzInstance, new HashSet(members));
        Assert.assertEquals((String)"First member was expected to be leader.", (Object)RoleInfo.LEADER, roleMap.get(chosenLeaderId));
    }
}

