/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;

public class TestTopology {
    private TestTopology() {
    }

    private static ClientConnectorAddresses wrapAsClientConnectorAddresses(AdvertisedSocketAddress advertisedSocketAddress) {
        return new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, advertisedSocketAddress)));
    }

    public static CoreServerInfo addressesForCore(int id) {
        AdvertisedSocketAddress raftServerAddress = new AdvertisedSocketAddress("localhost", 3000 + id);
        AdvertisedSocketAddress catchupServerAddress = new AdvertisedSocketAddress("localhost", 4000 + id);
        AdvertisedSocketAddress boltServerAddress = new AdvertisedSocketAddress("localhost", 5000 + id);
        return new CoreServerInfo(raftServerAddress, catchupServerAddress, TestTopology.wrapAsClientConnectorAddresses(boltServerAddress), Iterators.asSet((Object[])new String[]{"core", "core" + id}), "default");
    }

    public static ReadReplicaInfo addressesForReadReplica(int id) {
        AdvertisedSocketAddress advertisedSocketAddress = new AdvertisedSocketAddress("localhost", 6000 + id);
        ClientConnectorAddresses clientConnectorAddresses = new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, advertisedSocketAddress)));
        return new ReadReplicaInfo(clientConnectorAddresses, advertisedSocketAddress, Iterators.asSet((Object[])new String[]{"replica", "replica" + id}), "default");
    }

    public static Map<MemberId, ReadReplicaInfo> readReplicaInfoMap(int ... ids) {
        return Arrays.stream(ids).mapToObj(TestTopology::readReplicaInfo).collect(Collectors.toMap(p -> new MemberId(UUID.randomUUID()), Function.identity()));
    }

    private static ReadReplicaInfo readReplicaInfo(int id) {
        AdvertisedSocketAddress advertisedSocketAddress = new AdvertisedSocketAddress("localhost", 6000 + id);
        return new ReadReplicaInfo(new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, advertisedSocketAddress))), new AdvertisedSocketAddress("localhost", 4000 + id), Iterators.asSet((Object[])new String[]{"replica", "replica" + id}), "default");
    }
}

