/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery.procedures;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.procedures.InstalledProtocolsProcedure;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.collection.Pair;

public class InstalledProtocolsProcedureTest {
    private Pair<AdvertisedSocketAddress, ProtocolStack> outbound1 = Pair.of((Object)new AdvertisedSocketAddress("host1", 1), (Object)new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_1, Arrays.asList(new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY})));
    private Pair<AdvertisedSocketAddress, ProtocolStack> outbound2 = Pair.of((Object)new AdvertisedSocketAddress("host2", 2), (Object)new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_2, Arrays.asList(new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY, TestProtocols.TestModifierProtocols.ROT13})));
    private Pair<SocketAddress, ProtocolStack> inbound1 = Pair.of((Object)new SocketAddress("host3", 3), (Object)new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_3, Arrays.asList(new Protocol.ModifierProtocol[]{TestProtocols.TestModifierProtocols.SNAPPY})));
    private Pair<SocketAddress, ProtocolStack> inbound2 = Pair.of((Object)new SocketAddress("host4", 4), (Object)new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_4, Collections.emptyList()));

    @Test
    public void shouldHaveEmptyOutputIfNoInstalledProtocols() throws Throwable {
        InstalledProtocolsProcedure installedProtocolsProcedure = new InstalledProtocolsProcedure(Stream::empty, Stream::empty);
        RawIterator result = installedProtocolsProcedure.apply(null, null, null);
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldListOutboundProtocols() throws Throwable {
        InstalledProtocolsProcedure installedProtocolsProcedure = new InstalledProtocolsProcedure(() -> Stream.of(this.outbound1, this.outbound2), Stream::empty);
        RawIterator result = installedProtocolsProcedure.apply(null, null, null);
        Assert.assertThat((Object)result.next(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"outbound", "host1:1", "raft", 1L, "[TestSnappy]"}));
        Assert.assertThat((Object)result.next(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"outbound", "host2:2", "raft", 2L, "[TestSnappy,ROT13]"}));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldListInboundProtocols() throws Throwable {
        InstalledProtocolsProcedure installedProtocolsProcedure = new InstalledProtocolsProcedure(Stream::empty, () -> Stream.of(this.inbound1, this.inbound2));
        RawIterator result = installedProtocolsProcedure.apply(null, null, null);
        Assert.assertThat((Object)result.next(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"inbound", "host3:3", "raft", 3L, "[TestSnappy]"}));
        Assert.assertThat((Object)result.next(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"inbound", "host4:4", "raft", 4L, "[]"}));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldListInboundAndOutboundProtocols() throws Throwable {
        InstalledProtocolsProcedure installedProtocolsProcedure = new InstalledProtocolsProcedure(() -> Stream.of(this.outbound1, this.outbound2), () -> Stream.of(this.inbound1, this.inbound2));
        RawIterator result = installedProtocolsProcedure.apply(null, null, null);
        Assert.assertThat((Object)result.next(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"outbound", "host1:1", "raft", 1L, "[TestSnappy]"}));
        Assert.assertThat((Object)result.next(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"outbound", "host2:2", "raft", 2L, "[TestSnappy,ROT13]"}));
        Assert.assertThat((Object)result.next(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"inbound", "host3:3", "raft", 3L, "[TestSnappy]"}));
        Assert.assertThat((Object)result.next(), (Matcher)Matchers.arrayContaining((Object[])new Object[]{"inbound", "host4:4", "raft", 4L, "[]"}));
        Assert.assertFalse((boolean)result.hasNext());
    }
}

