/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.handlers;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class VoidPipelineWrapperFactoryTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void clientSslEncryptionPoliciesThrowException() {
        VoidPipelineWrapperFactory pipelineWrapperFactory = new VoidPipelineWrapperFactory();
        Config config = Config.defaults();
        config.augment(CausalClusteringSettings.ssl_policy, "cluster");
        NullLogProvider logProvider = NullLogProvider.getInstance();
        Dependencies dependencies = null;
        this.expectedException.expectMessage("Unexpected SSL policy causal_clustering.ssl_policy is a string");
        pipelineWrapperFactory.forClient(config, dependencies, (LogProvider)logProvider, CausalClusteringSettings.ssl_policy);
    }

    @Test
    public void serverSslEncryptionPoliciesThrowException() {
        VoidPipelineWrapperFactory pipelineWrapperFactory = new VoidPipelineWrapperFactory();
        Config config = Config.defaults();
        config.augment(OnlineBackupSettings.ssl_policy, "backup");
        NullLogProvider logProvider = NullLogProvider.getInstance();
        Dependencies dependencies = null;
        this.expectedException.expectMessage("Unexpected SSL policy dbms.backup.ssl_policy is a string");
        pipelineWrapperFactory.forServer(config, dependencies, (LogProvider)logProvider, OnlineBackupSettings.ssl_policy);
    }

    @Test
    public void clientAndServersWithoutPoliciesPass() {
        VoidPipelineWrapperFactory pipelineWrapperFactory = new VoidPipelineWrapperFactory();
        Config config = Config.defaults();
        NullLogProvider logProvider = NullLogProvider.getInstance();
        Dependencies dependencies = null;
        pipelineWrapperFactory.forServer(config, dependencies, (LogProvider)logProvider, CausalClusteringSettings.ssl_policy);
        pipelineWrapperFactory.forClient(config, dependencies, (LogProvider)logProvider, CausalClusteringSettings.ssl_policy);
        pipelineWrapperFactory.forServer(config, dependencies, (LogProvider)logProvider, OnlineBackupSettings.ssl_policy);
        pipelineWrapperFactory.forClient(config, dependencies, (LogProvider)logProvider, OnlineBackupSettings.ssl_policy);
    }
}

