/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.helper.CompositeSuspendable;
import org.neo4j.causalclustering.helper.Suspendable;

public class CompositeSuspendableTest {
    @Test
    public void shouldEnableAllAndDisableAllEvenIfTheyThrow() {
        AtomicInteger count = new AtomicInteger();
        CompositeSuspendable compositeSuspendable = new CompositeSuspendable();
        int amountOfSuspendable = 3;
        for (int i = 0; i < amountOfSuspendable; ++i) {
            compositeSuspendable.add(this.getSuspendable(count));
        }
        try {
            compositeSuspendable.enable();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)amountOfSuspendable, (long)count.get());
        try {
            compositeSuspendable.disable();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)count.get());
    }

    private Suspendable getSuspendable(final AtomicInteger count) {
        return new Suspendable(){

            public void enable() {
                count.incrementAndGet();
                Assert.fail();
            }

            public void disable() {
                count.decrementAndGet();
                Assert.fail();
            }
        };
    }
}

