/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.helper.RobustJobSchedulerWrapper;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.assertion.Assert;

public class RobustJobSchedulerWrapperTest {
    private final int DEFAULT_TIMEOUT_MS = 5000;
    @Rule
    public LifeRule schedulerLife = new LifeRule(true);
    private final JobScheduler actualScheduler = new CentralJobScheduler();
    private final Log log = (Log)Mockito.mock(Log.class);

    @Before
    public void setup() {
        this.schedulerLife.add((Lifecycle)this.actualScheduler);
    }

    @Test
    public void oneOffJobWithExceptionShouldLog() throws Exception {
        Log log = (Log)Mockito.mock(Log.class);
        RobustJobSchedulerWrapper robustWrapper = new RobustJobSchedulerWrapper(this.actualScheduler, log);
        AtomicInteger count = new AtomicInteger();
        IllegalStateException e = new IllegalStateException();
        JobScheduler.JobHandle jobHandle = robustWrapper.schedule("JobName", 100L, () -> {
            count.incrementAndGet();
            throw e;
        });
        Assert.assertEventually((String)"run count", count::get, (Matcher)Matchers.equalTo((Object)1), (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        jobHandle.waitTermination();
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.timeout((long)5000L).times(1))).warn("Uncaught exception", (Throwable)e);
    }

    @Test
    public void recurringJobWithExceptionShouldKeepRunning() throws Exception {
        RobustJobSchedulerWrapper robustWrapper = new RobustJobSchedulerWrapper(this.actualScheduler, this.log);
        AtomicInteger count = new AtomicInteger();
        IllegalStateException e = new IllegalStateException();
        int nRuns = 100;
        JobScheduler.JobHandle jobHandle = robustWrapper.scheduleRecurring("JobName", 1L, () -> {
            if (count.get() < nRuns) {
                count.incrementAndGet();
                throw e;
            }
        });
        Assert.assertEventually((String)"run count", count::get, (Matcher)Matchers.equalTo((Object)nRuns), (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        jobHandle.cancel(true);
        ((Log)Mockito.verify((Object)this.log, (VerificationMode)Mockito.timeout((long)5000L).times(nRuns))).warn("Uncaught exception", (Throwable)e);
    }

    @Test
    public void recurringJobWithErrorShouldStop() throws Exception {
        RobustJobSchedulerWrapper robustWrapper = new RobustJobSchedulerWrapper(this.actualScheduler, this.log);
        AtomicInteger count = new AtomicInteger();
        Error e = new Error();
        JobScheduler.JobHandle jobHandle = robustWrapper.scheduleRecurring("JobName", 1L, () -> {
            count.incrementAndGet();
            throw e;
        });
        Thread.sleep(50L);
        Assert.assertEventually((String)"run count", count::get, (Matcher)Matchers.equalTo((Object)1), (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        jobHandle.cancel(true);
        ((Log)Mockito.verify((Object)this.log, (VerificationMode)Mockito.timeout((long)5000L).times(1))).error("Uncaught error rethrown", (Throwable)e);
    }
}

