/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helpers;

import java.util.function.Supplier;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;

public class DataCreator {
    private DataCreator() {
    }

    public static CoreClusterMember createLabelledNodesWithProperty(Cluster cluster, int numberOfNodes, Label label, Supplier<Pair<String, Object>> propertyPair) throws Exception {
        CoreClusterMember last = null;
        for (int i = 0; i < numberOfNodes; ++i) {
            last = cluster.coreTx((db, tx) -> {
                Node node = db.createNode(new Label[]{label});
                node.setProperty((String)((Pair)propertyPair.get()).first(), ((Pair)propertyPair.get()).other());
                tx.success();
            });
        }
        return last;
    }

    public static CoreClusterMember createEmptyNodes(Cluster cluster, int numberOfNodes) throws Exception {
        CoreClusterMember last = null;
        for (int i = 0; i < numberOfNodes; ++i) {
            last = cluster.coreTx((db, tx) -> {
                db.createNode();
                tx.success();
            });
        }
        return last;
    }

    public static long countNodes(CoreClusterMember member) {
        long count;
        CoreGraphDatabase db = member.database();
        try (Transaction tx = db.beginTx();){
            count = Iterables.count((Iterable)db.getAllNodes());
            tx.success();
        }
        return count;
    }
}

