/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import co.unruly.matchers.OptionalMatchers;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ProtocolSelection;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.helpers.collection.Iterators;

public class ApplicationProtocolRepositoryTest {
    private ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, TestProtocols.TestApplicationProtocols.listVersionsOf(Protocol.ApplicationProtocolCategory.RAFT)));

    @Test
    public void shouldReturnEmptyIfUnknownVersion() {
        Optional applicationProtocol = this.applicationProtocolRepository.select(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), (Comparable)Integer.valueOf(-1));
        Assert.assertThat((Object)applicationProtocol, (Matcher)OptionalMatchers.empty());
    }

    @Test
    public void shouldReturnEmptyIfUnknownName() {
        Optional applicationProtocol = this.applicationProtocolRepository.select("not a real protocol", (Comparable)Integer.valueOf(1));
        Assert.assertThat((Object)applicationProtocol, (Matcher)OptionalMatchers.empty());
    }

    @Test
    public void shouldReturnEmptyIfNoVersions() {
        Optional applicationProtocol = this.applicationProtocolRepository.select(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Collections.emptySet());
        Assert.assertThat((Object)applicationProtocol, (Matcher)OptionalMatchers.empty());
    }

    @Test
    public void shouldReturnProtocolIfKnownNameAndVersion() {
        Optional applicationProtocol = this.applicationProtocolRepository.select(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), (Comparable)Integer.valueOf(1));
        Assert.assertThat((Object)applicationProtocol, (Matcher)OptionalMatchers.contains((Object)((Object)TestProtocols.TestApplicationProtocols.RAFT_1)));
    }

    @Test
    public void shouldReturnKnownProtocolVersionWhenFirstGivenVersionNotKnown() {
        Optional applicationProtocol = this.applicationProtocolRepository.select(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{-1, 1}));
        Assert.assertThat((Object)applicationProtocol, (Matcher)OptionalMatchers.contains((Object)((Object)TestProtocols.TestApplicationProtocols.RAFT_1)));
    }

    @Test
    public void shouldReturnApplicationProtocolOfHighestVersionNumberRequestedAndSupported() {
        Optional applicationProtocol = this.applicationProtocolRepository.select(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{389432, 1, 3, 2, 71234}));
        Assert.assertThat((Object)applicationProtocol, (Matcher)OptionalMatchers.contains((Object)((Object)TestProtocols.TestApplicationProtocols.RAFT_3)));
    }

    @Test
    public void shouldIncludeAllProtocolsInSelectionIfEmptyVersionsProvided() {
        ProtocolSelection protocolSelection = this.applicationProtocolRepository.getAll((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.emptyList());
        Object[] expectedRaftVersions = TestProtocols.TestApplicationProtocols.allVersionsOf(Protocol.ApplicationProtocolCategory.RAFT);
        Assert.assertThat((Object)protocolSelection.versions(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedRaftVersions));
    }

    @Test
    public void shouldIncludeProtocolsInSelectionWithVersionsLimitedByThoseConfigured() {
        Object[] expectedRaftVersions = new Integer[]{1};
        ProtocolSelection protocolSelection = this.applicationProtocolRepository.getAll((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Arrays.asList(expectedRaftVersions));
        Assert.assertThat((Object)protocolSelection.versions(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedRaftVersions));
    }

    @Test
    public void shouldIncludeProtocolsInSelectionWithVersionsLimitedByThoseExisting() {
        Object[] expectedRaftVersions = TestProtocols.TestApplicationProtocols.allVersionsOf(Protocol.ApplicationProtocolCategory.RAFT);
        List configuredRaftVersions = Stream.concat(Stream.of(expectedRaftVersions), Stream.of(Integer.valueOf(Integer.MAX_VALUE))).collect(Collectors.toList());
        ProtocolSelection protocolSelection = this.applicationProtocolRepository.getAll((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, configuredRaftVersions);
        Assert.assertThat((Object)protocolSelection.versions(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedRaftVersions));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfNoIntersectionBetweenExistingAndConfiguredVersions() {
        List<Integer> configuredRaftVersions = Arrays.asList(Integer.MAX_VALUE);
        this.applicationProtocolRepository.getAll((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, configuredRaftVersions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateIfDuplicateProtocolsSupplied() {
        Protocol.ApplicationProtocol protocol = new Protocol.ApplicationProtocol(){

            public String category() {
                return "foo";
            }

            public Integer implementation() {
                return 1;
            }
        };
        Protocol.ApplicationProtocol[] protocols = new Protocol.ApplicationProtocol[]{protocol, protocol};
        new ApplicationProtocolRepository(protocols, new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, TestProtocols.TestApplicationProtocols.listVersionsOf(Protocol.ApplicationProtocolCategory.RAFT)));
    }
}

