/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.helpers.DataCreator;
import org.neo4j.causalclustering.scenarios.DiscoveryServiceType;
import org.neo4j.test.causalclustering.ClusterRule;

@RunWith(value=Parameterized.class)
public class ClusterIpFamilyIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(3);
    private Cluster cluster;

    @Parameterized.Parameters(name="{0} {1} useWildcard={2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({DiscoveryServiceType.SHARED, IpFamily.IPV4, false}, {DiscoveryServiceType.SHARED, IpFamily.IPV6, true}, {DiscoveryServiceType.HAZELCAST, IpFamily.IPV4, false}, {DiscoveryServiceType.HAZELCAST, IpFamily.IPV6, false}, {DiscoveryServiceType.HAZELCAST, IpFamily.IPV4, true}, {DiscoveryServiceType.HAZELCAST, IpFamily.IPV6, true});
    }

    public ClusterIpFamilyIT(DiscoveryServiceType discoveryServiceType, IpFamily ipFamily, boolean useWildcard) {
        this.clusterRule.withDiscoveryServiceType(discoveryServiceType);
        this.clusterRule.withIpFamily(ipFamily).useWildcard(useWildcard);
    }

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldSetupClusterWithIPv6() throws Exception {
        int numberOfNodes = 10;
        CoreClusterMember leader = DataCreator.createEmptyNodes(this.cluster, numberOfNodes);
        Assert.assertEquals((long)numberOfNodes, (long)DataCreator.countNodes(leader));
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
        Cluster.dataMatchesEventually(leader, this.cluster.readReplicas());
    }
}

