/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.scenarios.DiscoveryServiceType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.test.causalclustering.ClusterRule;

public class WillNotBecomeLeaderIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withDiscoveryServiceType(DiscoveryServiceType.HAZELCAST).withSharedCoreParam(CausalClusteringSettings.multi_dc_license, "true");
    @Rule
    public ExpectedException exceptionMatcher = ExpectedException.none();

    @Test
    public void clusterShouldNotElectNewLeader() throws Exception {
        int leaderId = 0;
        this.clusterRule.withInstanceCoreParam(CausalClusteringSettings.refuse_to_be_leader, x -> {
            if (x == leaderId) {
                return "false";
            }
            return "true";
        });
        Cluster cluster = this.clusterRule.createCluster();
        cluster.start();
        Assert.assertEquals((long)leaderId, (long)cluster.awaitLeader().serverId());
        cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        cluster.removeCoreMemberWithServerId(leaderId);
        try {
            cluster.awaitLeader(10L, TimeUnit.SECONDS);
            Assert.fail((String)"Should not have elected a leader");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

