/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategiesLoader;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelectorTest;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class UpstreamDatabaseStrategiesLoaderTest {
    private MemberId myself = new MemberId(UUID.randomUUID());

    @Test
    public void shouldReturnConfiguredClassesOnly() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.upstream_selection_strategy, (String)"dummy");
        UpstreamDatabaseStrategiesLoader strategies = new UpstreamDatabaseStrategiesLoader((TopologyService)Mockito.mock(TopologyService.class), config, this.myself, (LogProvider)NullLogProvider.getInstance());
        Set upstreamDatabaseSelectionStrategies = Iterators.asSet((Iterator)strategies.iterator());
        Assert.assertEquals((long)1L, (long)upstreamDatabaseSelectionStrategies.size());
        Assert.assertEquals(UpstreamDatabaseStrategySelectorTest.DummyUpstreamDatabaseSelectionStrategy.class, (Object)upstreamDatabaseSelectionStrategies.stream().map(Object::getClass).findFirst().get());
    }

    @Test
    public void shouldReturnTheFirstStrategyThatWorksFromThoseConfigured() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.upstream_selection_strategy, (String)"yet-another-dummy,dummy,another-dummy");
        UpstreamDatabaseStrategiesLoader strategies = new UpstreamDatabaseStrategiesLoader((TopologyService)Mockito.mock(TopologyService.class), config, this.myself, (LogProvider)NullLogProvider.getInstance());
        Assert.assertEquals(UpstreamDatabaseStrategySelectorTest.YetAnotherDummyUpstreamDatabaseSelectionStrategy.class, ((UpstreamDatabaseSelectionStrategy)strategies.iterator().next()).getClass());
    }
}

