/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelector;
import org.neo4j.causalclustering.upstream.strategies.ConnectToRandomCoreServerStrategy;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class UpstreamDatabaseStrategySelectorTest {
    private MemberId dummyMemberId = new MemberId(UUID.randomUUID());

    @Test
    public void shouldReturnTheMemberIdFromFirstSucessfulStrategy() throws Exception {
        UpstreamDatabaseSelectionStrategy badOne = (UpstreamDatabaseSelectionStrategy)Mockito.mock(UpstreamDatabaseSelectionStrategy.class);
        Mockito.when((Object)badOne.upstreamDatabase()).thenReturn(Optional.empty());
        UpstreamDatabaseSelectionStrategy anotherBadOne = (UpstreamDatabaseSelectionStrategy)Mockito.mock(UpstreamDatabaseSelectionStrategy.class);
        Mockito.when((Object)anotherBadOne.upstreamDatabase()).thenReturn(Optional.empty());
        UpstreamDatabaseSelectionStrategy goodOne = (UpstreamDatabaseSelectionStrategy)Mockito.mock(UpstreamDatabaseSelectionStrategy.class);
        MemberId theMemberId = new MemberId(UUID.randomUUID());
        Mockito.when((Object)goodOne.upstreamDatabase()).thenReturn(Optional.of(theMemberId));
        UpstreamDatabaseStrategySelector selector = new UpstreamDatabaseStrategySelector(badOne, Iterables.iterable((Object[])new UpstreamDatabaseSelectionStrategy[]{goodOne, anotherBadOne}), (LogProvider)NullLogProvider.getInstance());
        MemberId result = selector.bestUpstreamDatabase();
        Assert.assertEquals((Object)theMemberId, (Object)result);
    }

    @Test
    public void shouldDefaultToRandomCoreServerIfNoOtherStrategySpecified() throws Exception {
        TopologyService topologyService = (TopologyService)Mockito.mock(TopologyService.class);
        MemberId memberId = new MemberId(UUID.randomUUID());
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)new CoreTopology(new ClusterId(UUID.randomUUID()), false, this.mapOf(memberId, (CoreServerInfo)Mockito.mock(CoreServerInfo.class))));
        ConnectToRandomCoreServerStrategy defaultStrategy = new ConnectToRandomCoreServerStrategy();
        defaultStrategy.inject(topologyService, Config.defaults(), (LogProvider)NullLogProvider.getInstance(), null);
        UpstreamDatabaseStrategySelector selector = new UpstreamDatabaseStrategySelector((UpstreamDatabaseSelectionStrategy)defaultStrategy);
        MemberId instance = selector.bestUpstreamDatabase();
        Assert.assertEquals((Object)memberId, (Object)instance);
    }

    @Test
    public void shouldUseSpecifiedStrategyInPreferenceToDefault() throws Exception {
        TopologyService topologyService = (TopologyService)Mockito.mock(TopologyService.class);
        MemberId memberId = new MemberId(UUID.randomUUID());
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)new CoreTopology(new ClusterId(UUID.randomUUID()), false, this.mapOf(memberId, (CoreServerInfo)Mockito.mock(CoreServerInfo.class))));
        ConnectToRandomCoreServerStrategy shouldNotUse = new ConnectToRandomCoreServerStrategy();
        UpstreamDatabaseSelectionStrategy mockStrategy = (UpstreamDatabaseSelectionStrategy)Mockito.mock(UpstreamDatabaseSelectionStrategy.class);
        Mockito.when((Object)mockStrategy.upstreamDatabase()).thenReturn(Optional.of(new MemberId(UUID.randomUUID())));
        UpstreamDatabaseStrategySelector selector = new UpstreamDatabaseStrategySelector((UpstreamDatabaseSelectionStrategy)shouldNotUse, Iterables.iterable((Object[])new UpstreamDatabaseSelectionStrategy[]{mockStrategy}), (LogProvider)NullLogProvider.getInstance());
        selector.bestUpstreamDatabase();
        ((UpstreamDatabaseSelectionStrategy)Mockito.verify((Object)mockStrategy, (VerificationMode)Mockito.times((int)2))).upstreamDatabase();
    }

    private Map<MemberId, CoreServerInfo> mapOf(MemberId memberId, CoreServerInfo coreServerInfo) {
        HashMap<MemberId, CoreServerInfo> map = new HashMap<MemberId, CoreServerInfo>();
        map.put(memberId, coreServerInfo);
        return map;
    }

    public static class YetAnotherDummyUpstreamDatabaseSelectionStrategy
    extends UpstreamDatabaseSelectionStrategy {
        public YetAnotherDummyUpstreamDatabaseSelectionStrategy() {
            super("yet-another-dummy", new String[0]);
        }

        public Optional<MemberId> upstreamDatabase() {
            return Optional.of(new MemberId(UUID.randomUUID()));
        }
    }

    public static class AnotherDummyUpstreamDatabaseSelectionStrategy
    extends UpstreamDatabaseSelectionStrategy {
        public AnotherDummyUpstreamDatabaseSelectionStrategy() {
            super("another-dummy", new String[0]);
        }

        public Optional<MemberId> upstreamDatabase() {
            return Optional.of(new MemberId(UUID.randomUUID()));
        }
    }

    public static class DummyUpstreamDatabaseSelectionStrategy
    extends UpstreamDatabaseSelectionStrategy {
        private MemberId memberId;

        public DummyUpstreamDatabaseSelectionStrategy() {
            super("dummy", new String[0]);
        }

        public Optional<MemberId> upstreamDatabase() {
            return Optional.ofNullable(this.memberId);
        }

        public void setMemberId(MemberId memberId) {
            this.memberId = memberId;
        }
    }
}

