/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.strategies.ConnectToRandomCoreServerStrategy;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ConnectToRandomCoreServerStrategyTest {
    @Test
    public void shouldConnectToRandomCoreServer() throws Exception {
        MemberId memberId1 = new MemberId(UUID.randomUUID());
        MemberId memberId2 = new MemberId(UUID.randomUUID());
        MemberId memberId3 = new MemberId(UUID.randomUUID());
        TopologyService topologyService = (TopologyService)Mockito.mock(TopologyService.class);
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)ConnectToRandomCoreServerStrategyTest.fakeCoreTopology(memberId1, memberId2, memberId3));
        ConnectToRandomCoreServerStrategy connectionStrategy = new ConnectToRandomCoreServerStrategy();
        connectionStrategy.inject(topologyService, Config.defaults(), (LogProvider)NullLogProvider.getInstance(), null);
        Optional memberId = connectionStrategy.upstreamDatabase();
        Assert.assertTrue((boolean)memberId.isPresent());
        Assert.assertThat(memberId.get(), (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.equalTo((Object)memberId1), (Matcher)CoreMatchers.equalTo((Object)memberId2), (Matcher)CoreMatchers.equalTo((Object)memberId3)));
    }

    static CoreTopology fakeCoreTopology(MemberId ... memberIds) {
        assert (memberIds.length > 0);
        ClusterId clusterId = new ClusterId(UUID.randomUUID());
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        int offset = 0;
        for (MemberId memberId : memberIds) {
            coreMembers.put(memberId, new CoreServerInfo(new AdvertisedSocketAddress("localhost", 5000 + offset), new AdvertisedSocketAddress("localhost", 6000 + offset), new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, new AdvertisedSocketAddress("localhost", 7000 + offset)))), Iterators.asSet((Object[])new String[]{"core"}), "default"));
            ++offset;
        }
        return new CoreTopology(clusterId, false, coreMembers);
    }
}

